load_pha("pha2[#row=3,4,9,10]")

load_arf(1,"heg_-1.arf")
load_arf(2,"heg_1.arf")
load_arf(3,"meg_-1.arf")
load_arf(4,"meg_1.arf")

load_rmf(1,"heg_-1.rmf")
load_rmf(2,"heg_1.rmf")
load_rmf(3,"meg_-1.rmf")
load_rmf(4,"meg_1.rmf")

group_counts(1,20)
group_counts(2,20)
group_counts(3,20)
group_counts(4,20)

notice_id(1,5.,7.)
notice_id(2,5.,7.)
notice_id(3,5.,7.)
notice_id(4,5.,7.)

plot("data",1,"data",2,"data",3,"data",4)
current_plot("all")
log_scale(Y_AXIS)
print_window("all",["format","eps"])

delete_data(3)
delete_data(4)

set_source(1,xspowerlaw.pow)
set_source(2,pow)

set_stat("chi2datavar")
fit()

show_fit()

plot("fit",1,"fit",2)
current_plot("all")
log_scale(Y_AXIS)
print_window("pl",["format","eps"])

create_model_component("xsgaussian","g1")
g1.norm=1.e-4

set_source(1,pow+g1)
set_source(2,pow+g1)
fit()

plot("fit",1,"fit",2)

set_proj_opt("sigma",1.64)
proj(g1.linee,g1.sigma,g1.norm)

plot("fit",1,"fit",2,"delchi",1,"delchi",2) 
current_plot("plot1")                           
log_scale(Y_AXIS)    
current_plot("plot2")
log_scale(Y_AXIS) 
print_window("sherpa_one_line",["format","eps"])

create_model_component("xsgaussian","g2")
g2.norm=1.e-4

set_model(1,pow+g1+g2)
set_model(2,pow+g1+g2)
fit()
proj()

plot("fit",1,"fit",2,"delchi",1,"delchi",2) 
current_plot("plot1")                           
log_scale(Y_AXIS)    
current_plot("plot2")
log_scale(Y_AXIS) 
print_window("sherpa_two_line",["format","eps"])

set_model(1,pow+g1)
set_model(2,pow+g1)
fit()

eqwidth(pow,pow+g1)

calc_photon_flux(6.,7.)
calc_energy_flux(6.,7.)

set_model(1,g1)
set_model(2,g1)
calc_photon_flux(6.,7.)
calc_energy_flux(6.,7.)
