clean()
show_method()

load_data("source_grouped_pi.fits")

notice(0.5,8.0)
plot_data()
log_scale(XY_AXIS)

set_source(xswabs.abs1*powlaw1d.p1)
fit()

plot("fit",1,"delchi",1)
current_plot("plot1")
log_scale(XY_AXIS)
current_plot("plot2")
log_scale(X_AXIS)
limits(X_AXIS,1,10)

print get_fit_results()


projection(p1.gamma)
set_proj_opt("sigma",1.6)
proj(p1.gamma,abs1.nH)

projection()


print get_int_proj()
int_proj(p1.gamma,min=1,max=2)
print get_int_proj()


print get_reg_proj()
reg_proj(p1.gamma,abs1.nH,sigma=[1,1.6])
print get_reg_proj()

reg_proj(p1.gamma,abs1.nH,min=[1.2,2],max=[1.9,2.8],nloop=[21,21],sigma=[1,1.6])
print get_reg_proj()

reg_proj(p1.gamma,abs1.nH,min=[1.2,2],max=[1.9,2.8],nloop=[100,100],sigma=[1,1.6])
print get_reg_proj()

add_window()
rp=get_reg_proj()
xp=rp.x0
yp=rp.x1
zp=rp.y

smin=get_reg_proj().levels
add_contour(xp,yp,zp,[smin[0]],["color","red"])
add_contour(xp,yp,zp,[smin[1]],["color","green"])
limits(X_AXIS,1.2,1.9)
limits(Y_AXIS,2,2.8)

add_line(1.25,2.75,1.32,2.75,["color","red"])
add_label(1.325,2.75,"1\sigma",["valign",0.5,"color","red"])

add_line(1.25,2.72,1.32,2.72,["color","green"])
add_label(1.325,2.72,"1.6\sigma",["valign",0.5,"color","green"])


