# SAOImageDS9 Demo for #AAS233 Chandra/CIAO workshop

Kenny J. Glotfelty

Center for Astrophysics | Harvard & Smithsonian

## Summary

This is a repository of `bash_kernel` Jupyter notebooks used to
demo `ds9` at AAS233.

## Table of Contents

- [Introduction and Setup](00_Introduction_and_Setup.ipynb)
- [Tweaking the User Interface](01_User_Interface.ipynb)
- [Bin, Block, Zoom](02_Bin_Block_Zoom.ipynb)
- [On the fly filtering](03_Bin_Menu_Filter.ipynb)
- Regions
    - [Style Decorations](04a_Region_Decorations.ipynb)
    - [Analysis Functions](04b_Regions_Functionality.ipynb)
    - [3D Analysis](04c_Regions_Cubes.ipynb)
- RGB aka 'True' Color
    - [Multiwave length](05a_RGB_energy.ipynb)
    - [Time Slices](05b_RGB_time.ipynb)
- [Custom Color Look Up Tables](06_Color_Look_Up_Tables.ipynb)
- [Backup and Restore](07_Backup_Restore.ipynb)
- [3D Rendering](08_3D_Rendering.ipynb)
- [Contours: Copy and Paste](09_Contours.ipynb)
- [Catalogs](10_Catalogs.ipynb)
- [Custom Analysis Commands](11_Analysis.ipynb)
- [DAX: `ds9` Analysis eXtensions](20_Dax.ipynb)
    - Statistics
    - Histograms
    - Sherpa



