-- spectrum generator call validation

local raygen 	= require( 'saotrace.raygen' )
local vobj 	= require( 'saotrace.raygen.validate').vobj
local intrinsic = require( 'saotrace.raygen.intrinsic.spectrum' )

local _PACKAGE = 'saotrace.raygen.spectrum'
local _M = {}

--------------------------
-- Object constructors; don't call directly;
-- use the type specific wrappers created below


local Base = {}

function Base:new( )

   local obj = {}
   setmetatable(obj, self)
   self.__index = self
   return obj

end

function Base:register( )

   return intrinsic[self.type](self.args)

end

function Base:isa( class )

   return class == _PACKAGE

end

function _M.default( args )

   args.energy = 1

   return _M.mono( args )

end

--------------------------
-- this holds the validation specifications for the generators.  it
-- cannot be local because intrinsic uses it to create mock functions

_M.vspec = {}
local vspec = _M.vspec

--------------------------

vspec.mono = {
   name   = { type = 'string' },
   energy = { type = 'posnum' },
   flux   = { type = 'posnum', default = 1 },
}

--------------------------

vspec.flat = {
   name = { type = 'string' },
   emin = { type = 'posnum' },
   emax = { type = 'posnum' },
   flux = { type = 'posnum', default = 1 },
}

--------------------------

vspec.file = {

   name = { type = 'string' },

   file = { type = 'string' },

   format = {
      enum = { 'rdb' }
   },

   emin = { type = 'string', default = 'emin' },
   emax = { type = 'string', default = 'emax' },
   flux = { type = 'string', default = 'flux' },

   units = {
      enum = { 'ergs/s/cm2/kev',
	       'kev/s/cm2/kev',
	       'photons/s/cm2'
	    }
   },

   scale = { type = 'posnum', default = 1.0 }

}

---------------------------

-- create wrappers around compiled functions

for gen, specs in pairs( vspec ) do

   _M[gen] = function (...)
		local obj = Base:new()
		obj.type = gen
		local ok, args = vobj:validate( specs, ... )
		if ok then
		   obj.args = args;
		   return obj
		else
		   return error( args, 2 )
		end
	     end
end

return _M
