-- --8<--8<--8<--8<--
--
-- Copyright (C) 2015 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.log
--
-- saotrace.log is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

local _logger

return {

   init = function ( ... )

	     if _logger then
		error( "must call saotrace.log.init first" )
	     end

	     local va = require( 'validate.args' )
	     local logging = require( 'logging' )

	     local ok, logfile, loglevel
		= va.validate( {
				 { type = 'string',
				   name = 'logfile',
				},
				 { enum ={"DEBUG", "INFO", "WARN", "ERROR", "FATAL"},
				   name = 'loglevel',
				   default = logging.WARN,
				},
			      },
			      ... )

	     if not ok then
		error( loglevel )
	     end

	     _logger = require( 'logging.file')( logfile )
	     _logger:setLevel( loglevel )

	     return _logger
	  end,

   logger = function ()

	       return _logger or error( "must call saotrace.log.init first" )

	    end
}

