local ea = require('saotrace.raygen.ea.create_from_db')
local source = require( 'chandra.saotrace.raygen.source' )
local jitter = require( 'chandra.saotrace.raygen.jitter' )
local tables = require( 'saotrace.suplib.tables' )

local require = require
local pairs   = pairs
local type    = type

local config = require( 'saotrace.config' ).raygen

-- sanitize arguments sent to saotrace.raygen.ea.create_from_db.entrance_aperture
-- args may be an environment returned by boxing a load of a file or string,
-- so may trigger an "unexpected elements" validation error

local function ea_wrap( args )

   return ea.entrance_aperture( tables.filter_matched_keys( ea.vspec, args ) )

end

-- trace-shell needs to provide the shell & db parameters
-- in config.scripts.entrance_aperture.args
config.scripts.entrance_aperture.func = ea_wrap

-- use the cleanup hook to ensure handle backwards compatibility
config.scripts.sources.cleanup = source.default

-- export a clean namespace with just the functions for the sources
-- and jitter
local _M = {}
for _, module in pairs{ source, jitter } do
   for k,v in pairs( module ) do
      if type(v) == 'function' then _M[k] = v end
   end
end

_M.default = nil


return _M
