from __future__ import print_function

from cxcdm import *
from cxcdm._cxcdm import _dmSetVerbose
import sys

# -------------------------------------------------------------------------
# User closes DM objects.. 
# -------------------------------------------------------------------------
def testTableMemory (infile, outfile=sys.stdout):
   _dmSetVerbose( 2 )

   print("dmTableOpen({0})            # open block".format (infile), file=outfile);
   b = dmTableOpen( infile )

   print("dmBlockGetDataset( b )         # grab dataset from block", file=outfile)
   ds  = dmBlockGetDataset( b )

   print("dmDatasetGetBlock( ds, 2 )     # new object to same block", file=outfile)
   tab = dmDatasetGetBlock( ds, 2 )

   print("dmTableClose( b )              # manually close block and ds", file=outfile)
   print("                               #  - ds and tab should become empty", file=outfile)
   dmTableClose( b )

   print("Check 'b'   is empty = ", dmIsEmpty( b ), file=outfile)
   print("Check 'tab' is empty = ", dmIsEmpty( tab ), file=outfile)
   print("Check 'ds'  is empty = ", dmIsEmpty( ds ), file=outfile)

   print("Delete b", file=outfile)
   del b

   print("Delete tab", file=outfile)
   del tab

   print("Delete ds", file=outfile)
   del ds


   print("# -------------------------------------------------------------------------", file=outfile)
   # Does not close DM objects.. lets the python dealloc functions take care of it.
   print("# -------------------------------------------------------------------------", file=outfile)


   print("dmTableOpen({0})            # open block".format(infile), file=outfile)
   b = dmTableOpen( infile )

   print("dmBlockGetDataset( b )         # grab dataset from block", file=outfile)
   ds  = dmBlockGetDataset( b )

   print("dmDatasetGetBlock( ds, 2 )     # new object to same block", file=outfile)
   tab = dmDatasetGetBlock( ds, 2 )

   print("Check 'b'   is empty = ", dmIsEmpty( b ), file=outfile)
   print("Check 'tab' is empty = ", dmIsEmpty( tab ), file=outfile)
   print("Check 'ds'  is empty = ", dmIsEmpty( ds ), file=outfile)

   print("Delete b", file=outfile)
   del b

   print("Delete tab", file=outfile)
   del tab

   print("Delete ds", file=outfile)
   del ds

   print("# -------------------------------------------------------------------------", file=outfile)
   print("# -------------------------------------------------------------------------", file=outfile)

   print("dmBlockOpen({0})            # open block".format (infile), file=outfile)
   b = dmBlockOpen( infile )

   print("dmBlockGetDataset( b )         # grab dataset from block", file=outfile)
   ds  = dmBlockGetDataset( b )

   print("dmDatasetMoveToBlock( ds, 2 )  # new object to same block (new C ptr)", file=outfile)
   tab = dmDatasetMoveToBlock( ds, 2 )

   print("dmBlockClose( b )              # manually close 1 block, ds remains open", file=outfile)
   dmBlockClose( b )

   print("del ds                         # drop python link to dataset.. ds remains open", file=outfile)
   del ds

   print("dmBlockClose( tab )            # manually close other block, ds remains open", file=outfile)
   dmBlockClose( tab )

   print("Check 'b'   is empty = ", dmIsEmpty( b ), file=outfile)
   print("Check 'tab' is empty = ", dmIsEmpty( tab ), file=outfile)

   del b
   del tab

   print("# -------------------------------------------------------------------------", file=outfile)
   # Lets get some descriptors in here!
   print("# -------------------------------------------------------------------------", file=outfile)


   print("dmBlockOpen({0})            # open block".format (infile), file=outfile)
   b = dmBlockOpen( infile )

   print("c = dmTableOpenColumn(b, 'FCOL')      # open a column ", file=outfile)
   c = dmTableOpenColumn(b, "FCOL")

   print("v = dmGetData( c )                    # pull out a value ", file=outfile)
   v = dmGetData( c )

   print("del b                                 # simulate leaving a subroutine.. return v", file=outfile)
   del b
   print("del c                                 # simulate leaving a subroutine.. return v", file=outfile)
   del c


   # Try deleting the descriptors first
   print("# -------------------------------------------------------------------------", file=outfile)

   print("dmBlockOpen({0})            # open block".format (infile), file=outfile)
   b = dmBlockOpen( infile )

   print("c = dmTableOpenColumn(b, 'FCOL')      # open a column ", file=outfile)
   c = dmTableOpenColumn(b, "FCOL")

   print("dmDescriptorDelete( c )               # delete the descriptor without deleting the variable ", file=outfile)
   try:
      dmDescriptorDelete( c )
   except:
      del c 
   else:
      print("v = dmGetData( c )                   # try to access data from the descriptor", file=outfile)
      v = dmGetData (c)

   print("del b                                 # now delete the block", file=outfile)
   del b


   _dmSetVerbose( 0 )

def testImageMemory (infile, outfile=sys.stdout):
   _dmSetVerbose( 2 )

   print("dmImageOpen({0})            # open block".format (infile), file=outfile)
   b = dmImageOpen( infile )

   print("dmImageClose( b )              # manually close block", file=outfile)
   print("                               # block and internal ds should be cleared ", file=outfile)
   dmImageClose( b )

   print("Check 'b'   is empty = ", dmIsEmpty( b ), file=outfile)

   print("Delete b", file=outfile)
   del b

   print("# -------------------------------------------------------------------------", file=outfile)
   # Does not close DM objects.. lets the python dealloc functions take care of it.
   print("# -------------------------------------------------------------------------", file=outfile)


   print("dmImageOpen({0})            # open block".format (infile), file=outfile)
   b = dmImageOpen( infile )

   print("dmBlockGetDataset( b )         # grab dataset from block", file=outfile)
   ds  = dmBlockGetDataset( b )

   print("dmDatasetGetBlock( ds, 2 )     # new object to same block", file=outfile)
   image = dmDatasetGetBlock( ds, 2 )

   print("Check 'b'   is empty = ", dmIsEmpty( b ), file=outfile)
   print("Check 'image' is empty = ", dmIsEmpty( image ), file=outfile)
   print("Check 'ds'  is empty = ", dmIsEmpty( ds ), file=outfile)

   print("Delete b", file=outfile)
   del b

   print("Check 'ds'  is empty = ", dmIsEmpty( ds ), file=outfile)

   print("Access the ds", file=outfile)
   dmDatasetGetName (ds)

   print("dmImageClose (image)", file=outfile)
   dmImageClose (image)

   print("Delete ds", file=outfile)
   del ds

   print("# -------------------------------------------------------------------------", file=outfile)
   print("# -------------------------------------------------------------------------", file=outfile)

   print("dmBlockOpen({0})            # open block".format (infile), file=outfile)
   b = dmBlockOpen( infile )

   print("dmBlockGetDataset( b )         # grab dataset from block", file=outfile)
   ds  = dmBlockGetDataset( b )

   print("dmDatasetMoveToBlock( ds, 2 )  # new object to same block (new C ptr)", file=outfile)
   image = dmDatasetMoveToBlock( ds, 2 )

   print("delete  b                      # delete 1 block, ds remains open", file=outfile)
   del b

   print("Check 'ds'  is empty = ", dmIsEmpty( ds ), file=outfile)

   print("del ds                         # drop python link to dataset.. ds remains open", file=outfile)
   del ds

   print("dmBlockClose( tab )            # manually close other block, ds remains open", file=outfile)
   dmBlockClose( image )

   print("Check 'image' is empty = ", dmIsEmpty( image ), file=outfile)

   del image 

   print("# -------------------------------------------------------------------------", file=outfile)
   # Lets get some descriptors in here! And a sub routine
   print("# -------------------------------------------------------------------------", file=outfile)


   def test ():
      print("dmBlockOpen({0})            # open block".format(infile), file=outfile)
      b = dmImageOpen( infile )

      print("dd = dmImageGetDataDescriptor(b)      # open an image ", file=outfile)
      dd = dmImageGetDataDescriptor(b)

      print("v = dmGetData( c )                    # pull out a value ", file=outfile)
      v = dmGetData( dd )

      print("v[:5]                                # extract 5 values", file=outfile)
      print(v[:5], file=outfile)
      

      return v

   data = test ()
   print("data[:5]                                # extract 5 values", file=outfile)

   print(data[:5], file=outfile)

# ----------------------------------------------------------------------
# Test refrence counts for true, false and none returns
# ----------------------------------------------------------------------
def testRefenceCounts (infile, outfile=sys.stdout):
   _dmSetVerbose( 0 )
   print("dmBlockOpen({0})            # open block".format (infile), file=outfile)
   b = dmBlockOpen( infile )
  
   print("btype = dmBlockGetType( b )  # get block type", file=outfile)
   btype = dmBlockGetType( b )

   print("sys.getrefcount (btype == dmIMAGE) == sys.getrefcount (btype == dmIMAGE)  # check refcount for false", file=outfile)
   print(sys.getrefcount (btype == dmIMAGE) == sys.getrefcount (btype == dmIMAGE), file=outfile)

   print("sys.getrefcount (btype == dmTABLE) == sys.getrefcount (btype == dmTABLE)  # check refcount for true", file=outfile)
   print(sys.getrefcount (btype == dmTABLE) == sys.getrefcount (btype == dmTABLE), file=outfile)

   print("dd = dmTableOpenColumn(b, 'FCOL')  # open descriptor", file=outfile)
   dd = dmTableOpenColumn(b, "FCOL")

   print("sys.getrefcount (dmDescriptorGetType (dd) == dmKEY) == sys.getrefcount (dmDescriptorGetType (dd) == dmKEY)   #check refcount for false", file=outfile)
   print(sys.getrefcount (dmDescriptorGetType (dd) == dmKEY) == sys.getrefcount (dmDescriptorGetType (dd) == dmKEY), file=outfile)

   print("sys.getrefcount (dmDescriptorGetType (dd) == dmCOLUMN) == sys.getrefcount (dmDescriptorGetType (dd) == dmCOLUMN)   #check refcount for false", file=outfile)
   print(sys.getrefcount (dmDescriptorGetType (dd) == dmCOLUMN) == sys.getrefcount (dmDescriptorGetType (dd) == dmCOLUMN), file=outfile)

   print("sys.getrefcount (dmIsEmpty(dd)) == sys.getrefcount (dmIsEmpty(dd))   #check refcount for false", file=outfile)
   print(sys.getrefcount (dmIsEmpty(dd)) == sys.getrefcount (dmIsEmpty(dd)), file=outfile)

   print("dmBlockClose (b)  # close block", file=outfile)
   dmBlockClose (b)
   print("sys.getrefcount (dmIsEmpty(dd)) == sys.getrefcount (dmIsEmpty(dd))   #check refcount for true", file=outfile)
   print(sys.getrefcount (dmIsEmpty(dd)) == sys.getrefcount (dmIsEmpty(dd)), file=outfile)

   print("dmBlockOpen({0})            # open block".format (infile), file=outfile)
   b = dmBlockOpen( infile )

   print("ds = dmBlockGetDataset (b)  # open dataset", file=outfile)
   ds = dmBlockGetDataset (b)

   print("dmDatasetClose (ds)         # close dataset", file=outfile)
   dmDatasetClose (ds)

   print("sys.getrefcount (dmIsEmpty(dd)) == sys.getrefcount (dmIsEmpty(dd))   #check refcount for true", file=outfile)
   print(sys.getrefcount (dmIsEmpty(dd)) == sys.getrefcount (dmIsEmpty(dd)), file=outfile)



if __name__ == "__main__":

   if len(sys.argv) == 4:
      ofile = sys.argv[3]
      fh = open( ofile, 'w')
   else:
      fh = sys.stdout

   testTableMemory (sys.argv[1], outfile=fh)
   testImageMemory (sys.argv[2], outfile=fh)
   testRefenceCounts (sys.argv[1], outfile=fh)


