#!/usr/bin/env python

# 
#  Copyright (C) 2009,2014-2015  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#


import os

try:
   import ciao_version as cv
except ImportError:
   import warnings
   warnings.warn("Unable to load the ciao_version module to determine version number- defaulting '%s' version to 0.0.0"%__name__, Warning)
   __version__ = "0.0.0"
else:
   __version__ = cv.get_ciao_version() 

try:
   if __ciao_ahelp_context__:
      pass
except:
   __ciao_ahelp_context__ = None

def ahelp (*args):
   cmd = ''
   for elem in args:
      try:
         # See if arg is a string-like object (can concat empty string)
         elem = elem + ''
      except TypeError:
         # Not a string- check for name attribute
         try:
             elem = elem.__name__
         except AttributeError:
             # cast to string
             elem = str(elem)
      cmd = cmd + ' ' + elem
   if cmd.find ('-x') == -1:
      os.system ("ahelp -x '/py[.]*/' "+cmd)
   else:
      os.system ("ahelp "+cmd)

