# 
#  Copyright (C) 2011-2012,2015-2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

"""
Pixlib - an interactive python pixlib API.
"""
from __future__ import print_function

# Enforce proper version requirements
import sys
if sys.version[0:3] < '2.7':
    raise ImportError('Python Version 2.7 or above is required for pixlib.')


from .pixlib import *

# Define what gets imported with a 'from pixlib import *'
__all__ = ['pixlib', 'pixhelp', 'usage', 'Pixlib']

# ciao_version module can be found in
# ../src/config/ciao_version.py
try:
    import ciao_version
    vstr = ciao_version.get_ciao_version()
except ImportError:                       
    print("Warning: Unable to load the ciao_version module to determine version number- defaulting 'pixlib' version to 0.0.0");
    vstr = "0.0.0" 

__version__    = vstr

