#!/bin/sh
# 
#  Copyright (C) 2015,2019-2023  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#


#
# If the users has never used IPython before, create the IPython
# directory and copy everything over by hand (so the user doesn't
# have to go through the initial setup)
#
# I do this because I haven't found a way to have IPython
# *silently* create the .ipython directory or populate it with the
# configuration files--I would rather do that than hunt around
# and copy files over by hand.

# This is a work around so that this script works in the development branch
case $ASCDS_INSTALL in
   *"/vobs/ASC_BUILD"* ) OTS_DIR=$ASCDS_INSTALL/ots/ ;;
   *)OTS_DIR=$ASCDS_INSTALL/ots/ ;;
esac

if [ -z $1 ]; then
  echo "ERROR: Must provide a tool name (e.g. sherpa)"
  exit 1
fi

if [ -z $2 ]; then
  echo "ERROR: Must provide a space separated list of rc file names (e.g .sherpa.rc)"
  exit 1
fi

tool=$1
rc_files=$2

batch_mode="no"

# if provided batch mode should be yes or no
if [ $# -eq 3 ]; then
  batch_mode=$3
fi




if [ -n "$HOME" ]
then

    # determine the ipython resource directory
    if [ -n "${IPYTHONDIR}" ]
    then
       IPY_DIR=${IPYTHONDIR}
    else
       IPY_DIR=${HOME}/.ipython
    fi

    # Find latest python dir; look for soft link, then 3.11 down to 3.9
    ASCDS_OTS_PY_DIR=""
    if [ -d $OTS_DIR/lib/python ]
    then
	ASCDS_OTS_PY_DIR=$OTS_DIR/lib/python
    elif [ -d $OTS_DIR/lib/python3.11 ] ; then
        ASCDS_OTS_PY_DIR=$OTS_DIR/lib/python3.11
    elif [ -d $OTS_DIR/lib/python3.10 ] ; then
	ASCDS_OTS_PY_DIR=$OTS_DIR/lib/python3.10
    elif [ -d $OTS_DIR/lib/python3.9 ] ; then
        ASCDS_OTS_PY_DIR=$OTS_DIR/lib/python3.9
    else
	ASCDS_OTS_PY_DIR=""
    fi

    ASCDS_PY_DIR=""
    if [ -d ${ASCDS_INSTALL}/lib/python ]
    then
	ASCDS_PY_DIR=${ASCDS_INSTALL}/lib/python
    elif [ -d ${ASCDS_INSTALL}/lib/python3.11 ] ; then
        ASCDS_PY_DIR=${ASCDS_INSTALL}/lib/python3.11
    elif [ -d ${ASCDS_INSTALL}/lib/python3.10 ] ; then
        ASCDS_PY_DIR=${ASCDS_INSTALL}/lib/python3.10
    elif [ -d ${ASCDS_INSTALL}/lib/python3.9 ] ; then
        ASCDS_PY_DIR=${ASCDS_INSTALL}/lib/python3.9
    else
	ASCDS_PY_DIR=""
    fi

    # add any missing files to the ipython resource directory
    if [ ! -d ${IPY_DIR} ]
    then
        mkdir ${IPY_DIR} 
    fi

    # clean up any ipython version .11 rc files
    old_ipy_files="`ls ${IPY_DIR}/ipythonrc* 2>/dev/null`"
    old_ipy_files="${old_ipy_files} `ls ${IPY_DIR}/ipy_user_conf.py 2>/dev/null`"
    old_ipy_files="${old_ipy_files} `ls ${IPY_DIR}/ciao-config.py 2>/dev/null`"

    old_ipy_files="$(printf "${old_ipy_files}" | sed -e 's/^[[:space:]]*//')"

    if [ ! -z "${old_ipy_files}" ]
    then
       OLD_IPY_DIR=${IPY_DIR}/old_ipython
       if [ ! -d ${OLD_IPY_DIR} ]
       then
          mkdir ${OLD_IPY_DIR}
       fi

       for file in "${old_ipy_files}"
       do
         mv $file ${OLD_IPY_DIR}
       done

       if [ -d ${IPY_DIR}/db ]
       then
         mv ${IPY_DIR}/db ${OLD_IPY_DIR}
       fi

       echo ""
       echo "ATTENTION: The old IPython files found in ${IPY_DIR} are not compatible with this version of ${tool}. They have been moved to ${OLD_IPY_DIR}."
       echo ""
    fi

    IPY_DIR_PROFILE=${IPY_DIR}/profile_${tool}
    CONFIG_DIR=${ASCDS_INSTALL}/config/${tool}
    if [ ! -d ${IPY_DIR_PROFILE} ]
    then
        ipython profile create ${tool} 2>/dev/null
        cp ${CONFIG_DIR}/ipython/ipython_config.py ${IPY_DIR}/profile_${tool}/
        chmod 444 ${IPY_DIR_PROFILE}/ipython_config.py
        cp ${CONFIG_DIR}/ipython/00-${tool}_startup.py ${IPY_DIR}/profile_${tool}/startup
        chmod 444 ${IPY_DIR_PROFILE}/startup/00-${tool}_startup.py
    elif [ $batch_mode != "yes" ]; then 

        

        diff ${CONFIG_DIR}/ipython/ipython_config.py ${IPY_DIR}/profile_${tool}/ipython_config.py 2>&1 >/dev/null
        diff_ipython_config=$?

        diff ${CONFIG_DIR}/ipython/00-${tool}_startup.py ${IPY_DIR}/profile_${tool}/startup 2>&1 >/dev/null
        diff_startup=$?

        if [ $diff_ipython_config -gt 0 ] || [ $diff_startup -gt 0 ]; then
           echo ""
           echo "ATTENTION: The IPython profile found in ${IPY_DIR_PROFILE} is not compatible with this version of ${tool}."
           echo ""
           printf "    Update to a compatible version? [Y/N]:"
           stty raw
           ANSWER=`dd bs=1 count=1 2>/dev/null`
           stty -raw
           echo ""     # print newline
           case "$ANSWER" in
              [yY] ) 
                     mv ${IPY_DIR_PROFILE}/ipython_config.py ${IPY_DIR_PROFILE}/ipython_config_`date "+%Y%m%d.%H:%M:%S"`.py
                     cp -f ${CONFIG_DIR}/ipython/ipython_config.py ${IPY_DIR_PROFILE}
                     chmod 444 ${IPY_DIR_PROFILE}/ipython_config.py
                     cp -f ${CONFIG_DIR}/ipython/00-${tool}_startup.py ${IPY_DIR_PROFILE}/startup/


                     chmod 444 ${IPY_DIR_PROFILE}/startup/00-${tool}_startup.py
		     echo ""
		     echo "    Updated: ${IPY_DIR_PROFILE}/ipython_config.py"
		     echo "";;
              *)  
		     echo ""
		     echo "    Profile NOT updated."
		     echo "";;
           esac
        fi 
    fi

# If the user doesn't have a local .rc file, copy it 

    for rc_file in $rc_files
    do
        if [ ! -f ${HOME}/${rc_file} ]
        then
            if [ -f ${CONFIG_DIR}/${rc_file} ]
            then
               cp ${CONFIG_DIR}/${rc_file} ${HOME}/${rc_file}
               chmod 644 ${HOME}/${rc_file}
            else
              echo "Warning: ${rc_file} file could not be found."
            fi
        fi
    done
fi

