/* mst_rdb: test main program for mst_rdb library
   9/18/95 rje */


#include <stdio.h>
#include <stddef.h>
#include <string.h>

#include <tracefct/tracefct.h>

#include <mst_rdb/mst_rdb.h>

int
main(int argc, char* argv[])
{
    FILE *infile;

    typedef struct {
	char *mirror;
	double x0;
	double y0;
	double z0;
	double rho0;
	double p;
	double k;
    } Tilt;

    Tilt data;
    long nlines;

    rdbHeader *head;
    DataColumnMap_st *map;

    char *fields[] = {
       "x0",
       "y0",
       "z0",
       "mirror",
       "rho0",
       "p",
       "k"
    };
    unsigned long nfields = 7;

    RDB_Type types[] = {  RDB_Num, RDB_Num, RDB_Num, RDB_String,
	RDB_Num, RDB_Num, RDB_Num };
    size_t offsets[7];

    tf_init(argv[0],0,-1);
    infile = fopen("tilt.rdb","r");

    offsets[0] = offsetof(Tilt, x0);
    offsets[1] = offsetof(Tilt, y0);
    offsets[2] = offsetof(Tilt, z0);
    offsets[3] = offsetof(Tilt, mirror);
    offsets[4] = offsetof(Tilt, rho0);
    offsets[5] = offsetof(Tilt, p);
    offsets[6] = offsetof(Tilt, k);

    head = rdb_rd_hdr(infile);

    map = rdb_map_cols_arst(head,nfields,fields,types,offsets);

    nlines = rdb_count(infile,head);
    printf("There are %lu lines in database.\n", (unsigned long) nlines);

    while(rdb_col_read_st(infile, head, map, &data))
    {
      /*
	...
      */
    }
    rdb_free_hdr(head);
    fclose(infile);

    return EXIT_SUCCESS;
}
