-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.suplib
--
-- saotrace.suplib is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

require('string')
local getenv = require('os').getenv

module( ... )

---------------------------------------------------------------------
-- interpolate variables into strings. variables may be of the form
-- $VAR or ${VAR}.  this implementation isn't quite correct as it
-- makes two passes over the string to handle the different syntaxes.
-- Lua patterns (at least in 3.1) don't seem to allow alternations

function interp(str, vars)

   local interp

   vars = vars or {}

   -- match $varname
   interp = str:gsub( "$([_%a]%w*)",
	      function( var )
		 return vars[ var ] or getenv( var ) or "$" .. var
	      end
	   )

   -- match ${varname}
   interp = interp:gsub( "${([_%a]%w*)}",
	      function( var )
		 return vars[ var ] or getenv( var ) or "${" .. var .. "}"
	      end
	   )

   return interp

end

-- split a line into tokens
-- see http://lua-users.org/lists/lua-l/2006-12/msg00414.html

function split(self, pat)
  local st, g = 1, self:gmatch("()("..pat..")")
  local function getter(self, segs, seps, sep, cap1, ...)
    st = sep and seps + #sep
    return self:sub(segs, (seps or 0) - 1), cap1 or sep, ...
  end
  local function splitter(self)
    if st then return getter(self, st, g()) end
  end
  return splitter, self
end


