-- --8<--8<--8<--8<--
--
-- Copyright (C) 2010 Smithsonian Astrophysical Observatory
--
-- This file is part of raygen
--
-- raygen is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

-- entrance aperture call validation

local merge = require( 'saotrace.suplib.tables' ).merge
local vobj = require( 'saotrace.raygen.validate').vobj
local raygen = require( 'saotrace.raygen' )


local _M = {}

--------------------------
-- table of ray distribution validation tables

local raydist = {

   random = { type = { enum = 'random' } },
}

local function vraydist ( args )

   if args then

      if args.type ~= nil and raydist[args.type] ~= nil then

	 return true, raydist[args.type]

      else

	 return false, "unknown entrance aperture ray distribution"

      end

   else

      return true,  { type = 'random' }

   end

end

--------------------------
-- this holds the validation specifications for the generators.  it
-- cannot be local because intrinsic uses it to create mock functions

_M.vspec = {}
local vspec = _M.vspec

vspec.annulus = {

   { name = 'name',   type = 'string' },
   { name = 'opts',

      vtable = {
	 x = { type = 'number', default = 0 },
	 y = { type = 'number', default = 0 },
	 z = { type = 'number', default = 0 },
	 ri = { type = 'zposnum' },
	 ro = { type = 'posnum' },
	 id = { type = 'eap_id', default = 0 },
      }
   }
}

--------------------------

vspec.circle = {
   { name = 'name',   type = 'string' },
   { name = 'opts',

      vtable = {
	 x = { type = 'number', default = 0 },
	 y = { type = 'number', default = 0 },
	 z = { type = 'number', default = 0 },
	 r = { type = 'posnum' },
	 id = { type = 'eap_id', default = 0 },
      }
   }
}

--------------------------

vspec.pinhole = {
   { name = 'name',   type = 'string' },
   { name = 'opts',
     optional = true,
     vtable = {
	 x = { type = 'number', default = 0 },
	 y = { type = 'number', default = 0 },
	 z = { type = 'number', default = 0 },
	 area = { type = 'posnum', default = 1 },
	 id = { type = 'eap_id', default = 0 },
      }
   }
}

--------------------------

vspec.wedge = {
   { name = 'name',   type = 'string' },
   { name = 'opts',

      vtable = {
	 x = { type = 'number', default = 0 },
	 y = { type = 'number', default = 0 },
	 z = { type = 'number', default = 0 },
	 ri = { type = 'zposnum' },
	 ro = { type = 'posnum' },
	 theta_min = { type = 'number' },
	 theta_max = { type = 'number' },
	 id = { type = 'eap_id', default = 0 },
      }
   }
}


-- fix up generators and create wrappers around compiled functions

local intrinsic = require( 'saotrace.raygen.intrinsic.ea' )

for gen, specs in pairs( vspec ) do

   -- need to incorporate ray distribution arguments into opts vtable
   if gen ~= 'pinhole' then

      for _, spec in pairs( specs ) do

	 -- look for spec with name = opts
	 if spec.name and spec.name == 'opts' then

	    spec.vtable = merge( spec.vtable,
				 { raydist = {
				      vtable = vraydist,
				      default = select( 2, vraydist(nil) )
				   }
				}
			      )
	 end

      end

   end

   -- now create the wrapper in the global namespace
   _M[gen] = function (...)
		  local ok, args = vobj:validate( specs, ... )

		  if ok then
		     return intrinsic[gen](args)
		  else
		     return error( args, 2 )
		  end
	       end
end

return _M
