#ifndef TPARAMS_H
#define TPARAMS_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of tparam
 *
 * tparam is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * tparam is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <stdarg.h>

#include <cxcparam/parameter.h>

/* *** begin protos *** */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
#if defined(__STDC__) || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif /* __STDC_ || __cplusplus */
/* tparam.c */
extern paramfile tparamopen(char *filename, char **argv, int argc, char *mode);
extern short tpgets(paramfile pf, char *pname);
extern int tpgeti(paramfile pf, char *pname);
extern double tpgetd(paramfile pf, char *pname);
extern float tpgetf(paramfile pf, char *pname);
extern int tpgetb(paramfile pf, char *pname);
extern char *tpgetstr(paramfile pf, char *pname, char *val, int nchars, int abort_if_empty);
#undef P_
#ifdef __cplusplus
}
#endif /* __cplusplus */
/* *** end protos *** */


#endif /* ! TPARAMS_H */
