#ifndef SUPLIB_UNITS_H_included
#define SUPLIB_UNITS_H_included

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of suplib
 *
 * suplib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * suplib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#ifdef __cplusplus
extern "C" {
#endif

enum
{
  UNITS_OK,		/* no error */
  UNITS_BADNUM,		/* the number was not parseable */
  UNITS_NOSPEC,		/* no units specification was present */
  UNITS_BADSPEC		/* the units specification wasn't recognized */
};

typedef struct
{
  double value;
  int unit;
} UnitVal;

typedef struct
{
  int id;
  double cnvfact;	/* factor which converts to fiducial unit */
} UnitConvert;

typedef struct
{
  UnitConvert *cvt;
  int nconv;
} UnitConvertList;
#define genUnitConvertList(s) {(s), sizeof(s) / sizeof(UnitConvert)}

typedef struct
{
  UnitConvertList *convert;
  TokList *map;
} UnitsList;

double	units_cvt( const UnitsList *list, int from, int to );
int	units_parse( const char *spec, UnitVal *uv, const UnitsList *list );

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* ! SUPLIB_UNITS_H_included */
