.\" Automatically generated by Pod::Man 2.28 (Pod::Simple 3.29)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{
.    if \nF \{
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "validate.args l"
.TH validate.args l "2016-09-06" " " " "
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
validate.args \- validate arguments and data structures
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
.Vb 1
\&  va = require(\*(Aqvalidate.args\*(Aq)
\&
\&  \-\- set some options which will affect
\&  \-\- all procedural calls
\&  va.opts{ options }
\&
\&  \-\- Procedural interface
\&
\&  \-\- foo( a, b )
\&  func foo( ... )
\&    local spec = { <specifications> }
\&    local ok, a, b = va.validate( spec, ... )
\&  end
\&
\&  \-\- goo( c, d )
\&  func goo( ... )
\&    local spec = { <specifications> }
\&    local ok, c, d = va.validate( options, spec, ... )
\&  end
\&
\&  \-\- Object based interface
\&  func foo( ... )
\&    local spec = { <specifications> }
\&    local vo = va:new()
\&    vo:setopts{ ... }
\&    local ok, a, b = vo:validate( spec, ... )
\&  end
.Ve
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBvalidate.args\fR provides a framework for validating function
arguments and data structures.  Scalar and (nested) table values as
well as lists of values of the same type may be validated.
.PP
\&\fBvalidate.args\fR provides both procedural and object-oriented
interfaces.  The significant difference between the interfaces is that
the procedural interface may be influenced by global settings while
the object-oriented interface keeps those settings local to each
object.  Objects may themselves be cloned, allowing for nested
hierarchies of validation specifications.  Changes to parent objects
do not affect child objects, and vice-versa.
.SS "Validating Function Arguments"
.IX Subsection "Validating Function Arguments"
Positional, named, and mixed positional and named arguments are
supported.  Positional arguments may be converted to named arguments
for uniformity of access (see \*(L"Validation Options\*(R").
.IP "Positional arguments" 4
.IX Item "Positional arguments"
.Vb 1
\&  foo( 3, \*(Aqn\*(Aq )
.Ve
.Sp
Positional arguments are not explicitly named when passed to the
function.  Their validation specifications are passed as a list,
one element per argument:
.Sp
.Vb 3
\&  { { pos1 specification },
\&    { pos2 specification }
\&  }
.Ve
.IP "Named arguments" 4
.IX Item "Named arguments"
.Vb 1
\&  goo{ a = 3, b = \*(Aqn\*(Aq }
.Ve
.Sp
Named arguments are passed as a single table to the function (notice
the \f(CW\*(C`{}\*(C'\fR syntactic sugar in the function invocation).
Their validation specifications are passed as a table:
.Sp
.Vb 3
\& { arg1_name = { arg1 specification },
\&   arg2_name = { arg2 specification }
\& }
.Ve
.ie n .IP """mixed"" mode" 4
.el .IP "``mixed'' mode" 4
.IX Item "mixed mode"
.Vb 1
\&  bar( 3, \*(Aqn\*(Aq, { c = 22 } )
.Ve
.Sp
Here a nested table is used to hold the named arguments. The table is
simply another positional argument, so the validation specifications
are passed as a list, one per argument:
.Sp
.Vb 4
\&  { { pos1 specification },
\&    { pos2 specification },
\&    { table specification }
\&  }
.Ve
.Sp
The validation specification for the table specifies the constraints
on the named arguments, typically using the \f(CW\*(C`vtable\*(C'\fR constraint.
.SS "Validating Data Structures"
.IX Subsection "Validating Data Structures"
Validation of data structures is very similar to validating function
arguments.  The base structure operated upon is a table whose elements
may be positional (indexed with integers) or named (indexed with
anything else) or both.  The layout of the validation specifications
are identical to those described above. Typically the \fBvalidate_tbl\fR
method or function is used.
.SS "Validation Specifications"
.IX Subsection "Validation Specifications"
A validation specification is a set of constraints which a value
must meet.  In most cases the specification is encoded in a table,
where each key-value pair represents a type of constraint and its
parameters.  The specification may also be specified by a function
(see \*(L"Mutating Validation Specifications\*(R").
.PP
\&\fBNote:\fR The documentation below refers to validation of both function
arguments and data structures. When the term \fIelement\fR is used it
refers to either a function argument or to an element of a data
structure.
.PP
Multiple constraints may be specified for each element. There are no
guarantees as to the order in which the constraints are applied.
.PP
The caller may provide constraints which modify the passed elements;
these must not expect a particular sequence of operation.
.PP
The caller may provide callbacks which are called pre\- and post\-
validation.  These may modify the elements.
.PP
The following specification parameters are recognized:
.IP "optional" 4
.IX Item "optional"
This is a boolean attribute which, if true, indicates that the element
need not be present.  Positional (as well as named elements) may be
optional; if they are not at the end of the list they must be specified
as \f(CW\*(C`nil\*(C'\fR in the list of input values, e.g.
.Sp
.Vb 1
\&  nil, 3
.Ve
.Sp
This defaults to \f(CW\*(C`false\*(C'\fR.  All elements are required by default.
.IP "default" 4
.IX Item "default"
This provides the default value when a element was not specified,
as well as indicating that the element is optional.  This may be a
function, which will be called if a default value is required. The
function is passed a single argument, a table (see \*(L"Callback
Arguments\*(R" for its contents). The function should return two values:
.RS 4
.IP "1." 4
a boolean indicating success or failure;
.IP "2." 4
the default value upon success, an error message upon failure
.RE
.RS 4
.Sp
If no default value is specified for a table element with a vtable
constraint, the nested specifications in the vtable are scanned for defaults.
.Sp
Note that if nested specifications are scanned for defaults and not all
of those specificatons provide defaults, an error will be thrown. To
avoid this, use \f(CW\*(C`default_is_nil\*(C'\fR
.RE
.IP "default_is_nil" 4
.IX Item "default_is_nil"
This indicates that the default value for an element is \f(CW\*(C`nil\*(C'\fR.
This is primarily used to indicate that nested vtable specifications
should not be scanned for defaults.
.IP "type" 4
.IX Item "type"
This specifies the expected type of the element. It may be either a
single type or a list of types.  See \*(L"Element Types\*(R" for more
information.  This is optional.
.IP "enum" 4
.IX Item "enum"
This specifies one or more explicit values which the element may
take. It may be either a single value or a list of values:
.Sp
.Vb 2
\&  enum = 33
\&  enum = { \*(Aqa\*(Aq, 33, \*(Aqb\*(Aq }
.Ve
.IP "allow_nil" 4
.IX Item "allow_nil"
This is a boolean and indicates that the element may be nil.  This
only pertains to positional elements.
.IP "not_nil" 4
.IX Item "not_nil"
This is a boolean and indicates that the element must not be nil.  This
only pertains to positional elements. \fI\s-1THIS IS DEPRECATED\s0\fR.  It defaults
to \f(CW\*(C`true\*(C'\fR.
.IP "requires" 4
.IX Item "requires"
This lists the names of one or more elements which \fImust\fR be specified
in addition to the current element.  The value is either a single
name or a list of names:
.Sp
.Vb 2
\&  requires = \*(Aqarg3\*(Aq
\&  requires = { \*(Aqarg3\*(Aq, \*(Aqarg4\*(Aq }
.Ve
.Sp
See also \*(L"Element Groups\*(R"
.IP "excludes" 4
.IX Item "excludes"
This lists the names of one or more elements which \fImay not\fR be specified
in addition to the current element.  The value is either a single
name or a list of names:
.Sp
.Vb 2
\&  excludes = \*(Aqarg3\*(Aq
\&  excludes = { \*(Aqarg3\*(Aq, \*(Aqarg4\*(Aq }
.Ve
.Sp
See also \*(L"Element Groups\*(R"
.IP "one_of" 4
.IX Item "one_of"
This provides a list of names of other elements of which exactly
one \fImust\fR be specified in addition to the current element:
.Sp
.Vb 1
\&  one_of = { \*(Aqarg3\*(Aq, \*(Aqarg4\*(Aq }
.Ve
.Sp
See also \*(L"Element Groups\*(R"
.IP "vfunc" 4
.IX Item "vfunc"
This specifies a function which is called to validate the element.
It is called with two arguments, the passed element value and a table
(see \*(L"Callback Arguments\*(R" for its contents).  It must return two
values:
.RS 4
.IP "1." 4
a boolean indicating success or failure;
.IP "2." 4
the (possibly modified) element value upon success, an error message upon failure
.RE
.RS 4
.Sp
For example,
.Sp
.Vb 6
\&  vfunc = function( orig )
\&            if type(orig) == \*(Aqnumber\*(Aq and orig >= 3 then
\&              return true, orig / 22
\&            end
\&              return false, \*(Aqnot a number or less then 3\*(Aq
\&          end
.Ve
.RE
.IP "vtable" 4
.IX Item "vtable"
This is used to validate the contents of an element which is a table.
Its value may be either:
.RS 4
.IP "a table of specifications" 4
.IX Item "a table of specifications"
There should be one element in the specification table for each element
in the element table. For example, to validate a call such as
.Sp
.Vb 1
\&  foo( \*(Aqhello\*(Aq, { nv1 = 3, nv2 = 2 } )
.Ve
.Sp
Use
.Sp
.Vb 7
\&  spec = { { type = \*(Aqstring\*(Aq },
\&           { vtable = { nv1 = { type = \*(Aqposint\*(Aq },
\&                        nv2 = { type = \*(Aqint\*(Aq },
\&                      }
\&           }
\&         }
\&  ok, pos, tbl = validate( spec, ... )
.Ve
.Sp
which will return
.Sp
.Vb 2
\&   pos = \*(Aqhello\*(Aq
\&   tbl = { nv1 = 3, nv2 = 2 }
\&
\& in the above invocation.
.Ve
.IP "a function" 4
.IX Item "a function"
The function is called with two arguments: the passed element value,
and a table (see \*(L"Callback Arguments\*(R" for its contents) and must
return two values:
.RS 4
.IP "1." 4
a boolean indicating success or failure;
.IP "2." 4
Upon success, a table of validation specifications. Upon failure, an
error message.  See \*(L"\s-1EXAMPLES\*(R"\s0 for an example of this in use.
.RE
.RS 4
.Sp
This function may be called with the element value equal to \f(CW\*(C`nil\*(C'\fR if
no element value was specified.
.RE
.RE
.RS 4
.RE
.IP "ordered" 4
.IX Item "ordered"
If an element is a vtable and this parameter is true, the vtable's elements will
be processed in the order specified by elements' \f(CW\*(C`order\*(C'\fR parameters.
.Sp
This is useful if elements have callback functions which must be called
in a specific order.
.Sp
To specify the \f(CW\*(C`ordered\*(C'\fR attribute for \fIimplicit\fR vtables you must
use the \f(CW\*(C`ordered\*(C'\fR validation option. Implicit vtables are created for
the specification passed to \fBvalidate_tbl\fR and for pure named-element
specifications passed to \fBvalidate\fR.
.IP "order" 4
.IX Item "order"
If an element is \fIin\fR a vtable and the vtable has \f(CW\*(C`ordered\*(C'\fR set,
this specifies the \*(L"weight\*(R" of the item; elements with smaller weights
will be processed before elements with larger weights.  \fBNote:\fR if
an element specification is generated by a function (see
\&\*(L"Mutating Validation Specifications\*(R")  its \f(CW\*(C`order\*(C'\fR parameter is
\&\fIignored\fR, as the order of validation is determined prior to validation
of the elements and mutating functions are called during validation.
.IP "before" 4
.IX Item "before"
.PD 0
.IP "after" 4
.IX Item "after"
.PD
Functions to be called for each element before and after
validation.  They are called with two arguments: the passed element
value, and a table (see \*(L"Callback Arguments\*(R" for its contents).  If
the function wishes to modify the element value it should return two
arguments, \f(CW\*(C`true\*(C'\fR and the new value, else it should return \f(CW\*(C`false\*(C'\fR.
.Sp
Please note:
.RS 4
.IP "\(bu" 4
If an error occurs during validation, the \f(CW\*(C`after\*(C'\fR function
will not be called.
.IP "\(bu" 4
Specification validation is done before the \f(CW\*(C`before\*(C'\fR function is
invoked.  If a specification is invalid neither callback is invoked.
.IP "\(bu" 4
The functions are called at the table level for elements which are
vtables.
.IP "\(bu" 4
These were previously named \f(CW\*(C`precall\*(C'\fR and \f(CW\*(C`postcall\*(C'\fR.  These
names are \fB\s-1DEPRECATED\s0\fR.
.RE
.RS 4
.RE
.IP "name" 4
.IX Item "name"
A name for a positional element.  If specified and the \f(CW\*(C`named\*(C'\fR
validation option is \fItrue\fR, then the element will be assigned this
name in the returned table.  See \*(L"Validation Options\*(R" for
more information.
.IP "named" 4
.IX Item "named"
Indicate that a name should be (or not be) assigned to a positional
element. This option overrides the validation option of the same name,
and is useful for control over particular elements.
.Sp
This option can only be specified for positional elements in tables,
not at the top level of the data structure, e.g.
.Sp
.Vb 1
\&  spec = { { name = \*(Aqfoo\*(Aq, named = true } }
.Ve
.Sp
will cause an error to be thrown, while
.Sp
.Vb 1
\&  spec = { data = { vtable = { { name = \*(Aqfoo\*(Aq, named = true } } }}
.Ve
.Sp
is legal.  Use the \f(CW\*(C`named\*(C'\fR validation option to assign names to top
level positional elements.
.IP "multiple" 4
.IX Item "multiple"
This indicates that the element is a table whose members must
each meet the validation specifications.  For example, to validate
a list of positive integers:
.Sp
.Vb 1
\&  { type = \*(Aqposint\*(Aq, multiple = true }
.Ve
.Sp
This parameter may take the following values:
.RS 4
.ie n .IP """true"" or ""false""" 4
.el .IP "\f(CWtrue\fR or \f(CWfalse\fR" 4
.IX Item "true or false"
If \f(CW\*(C`true\*(C'\fR, each member of the element table is validated.
.IP "a table of options" 4
.IX Item "a table of options"
In addition to validating the members of the input table, further
validation is possible.  The following options are recognized:
.RS 4
.IP "n" 4
.IX Item "n"
This specifies the exact number of members in the element table.  It is optional.
.IP "min" 4
.IX Item "min"
This specifies the required minimum number of members in the element
table.  It may not be combined with the \fBn\fR option.  It is optional.
.IP "max" 4
.IX Item "max"
This specifies the required maximum number of members in the element
table.  It may not be combined with the \fBn\fR option.  It is optional.
.IP "keys" 4
.IX Item "keys"
This specifies a validation specification for the \fIkeys\fR in the element table.
It is optional.
.Sp
For example, the following ensures that keys consist only of alphabetical characters:
.Sp
.Vb 10
\&  multiple = {
\&     keys = {
\&       vfunc = function( val )
\&                 if type(val) == \*(Aqstring\*(Aq
\&                    and val:match( \*(Aq^%a+$\*(Aq ) then
\&                   return true, val
\&                 else
\&                   return false,
\&                          "only alpha characters allowed"
\&                 end
\&               end
\&         }
\&  }
.Ve
.IP "allow_scalar" 4
.IX Item "allow_scalar"
Normally, indicating a multiplicity implies that the element must be a
table.  This ensures that there is no confusion if the members of that
table are themselves tables For.  example, is
.Sp
.Vb 1
\&  foo = { a = 2 }
.Ve
.Sp
a table of multiple values (with multiplicity of 1) or is it a single value
which happens to be a table?
.Sp
If the element is a scalar, there is no confusion. If this option is \fBtrue\fR,
\&\fBvalidate.args\fR will upgrade the element to a table.
.Sp
This option defaults to \fBfalse\fR
.RE
.RS 4
.RE
.RE
.RS 4
.RE
.SS "Element Types"
.IX Subsection "Element Types"
\&\fBvalidate.args\fR supports two schemes for specifying element types for the \f(CW\*(C`type\*(C'\fR option:
\&\fIsimple\fR and \fIinline\fR.
.PP
Simple types include the standard Lua types and can be augmented using
the \fBadd_type\fR function or method.  They are specified using their name (as a string):
.IP "'number'" 4
.IX Item "'number'"
.PD 0
.IP "'string'" 4
.IX Item "'string'"
.IP "'boolean'" 4
.IX Item "'boolean'"
.IP "'table'" 4
.IX Item "'table'"
.IP "'function'" 4
.IX Item "'function'"
.IP "'thread'" 4
.IX Item "'thread'"
.IP "'userdata'" 4
.IX Item "'userdata'"
.PD
These are the built-in types as returned by the Lua \fBtype\fR function.
.IP "'posnum'" 4
.IX Item "'posnum'"
The element must be a number greater than zero.
.IP "'zposnum'" 4
.IX Item "'zposnum'"
The element must be a number greater than or equal to zero.
.IP "'posint'" 4
.IX Item "'posint'"
The element must be an integer greater than zero.
.IP "'zposint'" 4
.IX Item "'zposint'"
The element must be an integer greater than or equal to zero.
.PP
Inline types are specified as tables of validation  specifications.
They are a bit more complex.
.IP "1." 4
When using inline type specifications, the specifications must be
passed to the \f(CW\*(C`types\*(C'\fR option as a \fIlist\fR of types, even if there is
only one specification.
.IP "2." 4
Inline types must be given a name.  It should not be the same as
the name of any simple type.
.PP
For example,  here is the type specification for the \fBmultiple\fR option:
.PP
.Vb 10
\&     type = { \*(Aqboolean\*(Aq,
\&              [\*(Aqmultiple table\*(Aq] = {
\&                 vtable = {
\&                    min = { type = \*(Aqzposint\*(Aq, optional = true,
\&                            excludes = \*(Aqn\*(Aq
\&                         },
\&                    max = { type = \*(Aqposint\*(Aq,  optional = true,
\&                            excludes = \*(Aqn\*(Aq
\&                         },
\&                    n   = { type = \*(Aqposint\*(Aq,  optional = true,
\&                            excludes = { \*(Aqmin\*(Aq, \*(Aqmax\*(Aq }
\&                         },
\&                    keys   = { vtable = validate_spec,
\&                               optional = true
\&                            },
\&                    allow_scalar = { type = \*(Aqboolean\*(Aq, default = false },
\&                 }
\&              }
\&           },
.Ve
.PP
It indicates that \fBmultiple\fR may either be a boolean value or a table
which may have the elements \f(CW\*(C`min\*(C'\fR, \f(CW\*(C`max\*(C'\fR, c<n>, etc.
.SS "Callback Arguments"
.IX Subsection "Callback Arguments"
Several of the validation specification entries take callback
functions.  The last argument passed to these functions is a table
containing the following named entries:
.IP "va" 4
.IX Item "va"
The validation object.  In the case that the procedural interface is
being used, this will be a default object.
.IP "name" 4
.IX Item "name"
The fully qualified name of the element stored as a
\&\f(CW\*(C`validate.args.Name\*(C'\fR object.  Use the \f(CW\*(C`tostring()\*(C'\fR function (or
the similarly named method) to stringify it.
.IP "spec" 4
.IX Item "spec"
The specification table for the element. \fBDo not modify this\fR.
.SS "Catch-all Specifications"
.IX Subsection "Catch-all Specifications"
It is possible to provide default specifications for named or
positional elements in tables.  These are passed as specifications for
the special names \f(CW%named\fR and \f(CW%pos\fR.  A third special name
\&\f(CW%default\fR is an alternative which can be used to provide a catch-all
for all unmatched elements.
.PP
The specifications must be functions. They are passed the element name
or position and its value.
.PP
If the element is \fIacceptable\fR, the function must return a true
boolean value and a specification table for the element.
.PP
If the element is \fInot acceptable\fR, the function must return a false
boolean value.  The function may also optionally return an error
message (otherwise a generic error message is generated).
.PP
For example, to catch all even numbered positional elements in a table
after the first two:
.PP
.Vb 10
\&    vtable = {
\&       { name = "first", type = \*(Aqstring\*(Aq },
\&       { name = "second", type = \*(Aqtable\*(Aq },
\&       [%pos] = function (k,v)
\&                   \-\-only look at even numbered positions
\&                   if k%2 == 0 then
\&                     return true, { type = \*(Aqposint\*(Aq }
\&                   else
\&                     \-\- ignore odd numbers
\&                     return false
\&                   end
\&                end
\&    }
.Ve
.SS "Mutating Validation Specifications"
.IX Subsection "Mutating Validation Specifications"
A validation specification is usually (as documented above) a table of
constraints.  In the case where the entire validation table must be
created on the fly the validation specification may be a \fIfunction\fR.
The function should take a single parameter \- the passed element
\&\fIvalue\fR \- and must return two values:
.IP "1." 4
a boolean indicating success or failure;
.IP "2." 4
Upon success, a table of validation specifications. Upon failure, an error message.
.SS "Element Groups"
.IX Subsection "Element Groups"
Some operations on groups of elements are possible for named
elements.  These are specified as special \*(L"names\*(R" in the
validation specification.  In order to accomodate multiple groups,
these \*(L"names\*(R" take as values a \fIlist of lists\fR,
.PP
.Vb 1
\&  [\*(Aq%one_of\*(Aq] = { { \*(Aqa\*(Aq, \*(Aqb\*(Aq, \*(Aqc\*(Aq } }
.Ve
.PP
\&\fBnot\fR a simple list:
.PP
.Vb 1
\&  [\*(Aq%one_of\*(Aq] = { \*(Aqa\*(Aq, \*(Aqb\*(Aq, \*(Aqc\*(Aq }
.Ve
.PP
This allows specifying multiple groups:
.PP
.Vb 1
\&  [\*(Aq%one_of\*(Aq] = { { \*(Aqa\*(Aq, \*(Aqb\*(Aq, \*(Aqc\*(Aq } , { \*(Aqd\*(Aq, \*(Aqe\*(Aq, \*(Aqf\*(Aq } }
.Ve
.ie n .IP "%one_of" 4
.el .IP "\f(CW%one_of\fR" 4
.IX Item "%one_of"
This ensures that exactly one element in a group is specified.  For
example, say that the caller must provide exactly one of the elements
\&\f(CW\*(C`arg1\*(C'\fR, \f(CW\*(C`arg2\*(C'\fR, or \f(CW\*(C`arg3\*(C'\fR.  Exclusivity is obtained via
.Sp
.Vb 3
\&  arg1 = { optional = true, excludes = { \*(Aqarg2\*(Aq, \*(Aqarg3\*(Aq } },
\&  arg2 = { optional = true, excludes = { \*(Aqarg1\*(Aq, \*(Aqarg3\*(Aq } },
\&  arg3 = { optional = true, excludes = { \*(Aqarg1\*(Aq, \*(Aqarg2\*(Aq } }
.Ve
.Sp
But that doesn't force the user to specify any.  This addition will:
.Sp
.Vb 1
\&  [\*(Aq%one_of\*(Aq] = {{ \*(Aqarg1\*(Aq, \*(Aqarg2\*(Aq, \*(Aqarg3\*(Aq }}
.Ve
.Sp
Note that specifying the \f(CW\*(C`excludes\*(C'\fR attribute is redundant with \f(CW%one_of\fR,
so the above could be rewritten as
.Sp
.Vb 4
\&  arg1 = { optional = true },
\&  arg2 = { optional = true },
\&  arg3 = { optional = true }
\&  [\*(Aq%one_of\*(Aq] = {{ \*(Aqarg1\*(Aq, \*(Aqarg2\*(Aq, \*(Aqarg3\*(Aq }}
.Ve
.ie n .IP "%oneplus_of" 4
.el .IP "\f(CW%oneplus_of\fR" 4
.IX Item "%oneplus_of"
This ensures that at least one element in a group is specified. More
may be specified.  As a complicated example:
.Sp
.Vb 4
\&  sigma   = { optional = true, excludes = { \*(Aqsigma_x\*(Aq, \*(Aqsigma_y\*(Aq } },
\&  sigma_x = { optional = true, requires = { \*(Aqsigma_y\*(Aq } },
\&  sigma_y = { optional = true, requires = { \*(Aqsigma_x\*(Aq } },
\&  [\*(Aq%oneplus_of\*(Aq] = { { \*(Aqsigma_x\*(Aq, \*(Aqsigma_y\*(Aq, \*(Aqsigma\*(Aq } },
.Ve
.Sp
ensures that only one of the two following situations occurs:
.Sp
.Vb 2
\&  sigma
\&  sigma_x sigma_y
.Ve
.SS "Validation Options"
.IX Subsection "Validation Options"
There are a few options which affect the validation process.  How they
are specifed depends upon whether the procedural or object-oriented
interfaces are used; see \*(L"Procedural interface\*(R" and \*(L"Object
oriented interface\*(R" for more details.
.IP "before" 4
.IX Item "before"
This specifies a function which is called with the input data prior to
any validation.  The data are passed as a table, which may be
modified.  The function should return a boolean indicating success or
failure; in the latter case it should also return an error mesage.
.IP "after" 4
.IX Item "after"
This specifies a function which is called with the completely
validated data prior to returning to the calling routine.  The data
are passed as a table, which may be modified.  The function should
return a boolean indicating success or failure; in the latter case it
should also return an error mesage.
.IP "check_spec" 4
.IX Item "check_spec"
By default the passed validation specification is not itself checked
for consistency, as this may be too much of a performance hit.  Setting
this to \f(CW\*(C`true\*(C'\fR will cause the specifications to be checked.
.Sp
This defaults to \f(CW\*(C`false\*(C'\fR.
.IP "error_on_invalid" 4
.IX Item "error_on_invalid"
If \f(CW\*(C`true\*(C'\fR, the Lua \fB\f(BIerror()\fB\fR function will be called the case of
invalid elements instead of returning a status code and message.
.Sp
This defaults to \f(CW\*(C`false\*(C'\fR.
.IP "error_on_bad_spec" 4
.IX Item "error_on_bad_spec"
If this is \f(CW\*(C`true\*(C'\fR, an invalid validation specification will result in a
call to the Lua \fB\f(BIerror()\fB\fR function.
.Sp
This defaults to \f(CW\*(C`false\*(C'\fR.
.IP "named" 4
.IX Item "named"
If this is \f(CW\*(C`true\*(C'\fR, positional elements are returned as a table, with
their names given either by the \f(CW\*(C`name\*(C'\fR attribute in the validation
specification or by their cardinal index in the argument list.
For example:
.Sp
.Vb 4
\&   ok, opts = validate_opts( { named = true },
\&                             { { name = a }, { }, },
\&                             22, 3
\&                              )
.Ve
.Sp
will result in
.Sp
.Vb 2
\&   opts.a = 22
\&   opts[2] = 3
.Ve
.Sp
This defaults to \f(CW\*(C`false\*(C'\fR.
.IP "allow_extra" 4
.IX Item "allow_extra"
If this is \f(CW\*(C`true\*(C'\fR, then any extra elements (either named or positional)
which are not mentioned in the validation specification are quietly
ignored. For example:
.Sp
.Vb 5
\&  local ok, a, b, c = validate_opts( { allow_extra = true,
\&                                       pass_through = true,
\&                                      },
\&                                      { {}, {} },
\&                                     1, 2, 3)
.Ve
.Sp
would result in
.Sp
.Vb 3
\&  a = 1
\&  b = 2
\&  c = nil
.Ve
.Sp
This defaults to \f(CW\*(C`false\*(C'\fR.
.IP "pass_through" 4
.IX Item "pass_through"
If this is \f(CW\*(C`true\*(C'\fR and \f(CW\*(C`allow_extra\*(C'\fR is also \f(CW\*(C`true\*(C'\fR, then any extra
elements (either named or positional) which are not mentioned in the
validation specification are passed through.  For example:
.Sp
.Vb 5
\&  local ok, a, b, c = validate_opts( { allow_extra = true,
\&                                       pass_through = true,
\&                                      },
\&                                      { {}, {} },
\&                                     1, 2, 3)
.Ve
.Sp
would result in
.Sp
.Vb 3
\&  a = 1
\&  b = 2
\&  c = 3
.Ve
.Sp
This defaults to \f(CW\*(C`false\*(C'\fR.
.IP "udata" 4
.IX Item "udata"
This option is used to pass arbitrary data to the callback routines.
Use the \f(CW\*(C`getopt\*(C'\fR method to retrieve it.
.IP "ordered" 4
.IX Item "ordered"
If this is true, implicit vtables will be processed in order specified
by their elements' \f(CW\*(C`order\*(C'\fR parameters.  See the documentation
for the \f(CW\*(C`ordered\*(C'\fR validation specification for more information.
.SS "Object oriented interface"
.IX Subsection "Object oriented interface"
\fIConstructors\fR
.IX Subsection "Constructors"
.PP
There are two available constructors: a constructor based upon class defaults
and one based upon an object:
.IP "Class constructor" 4
.IX Item "Class constructor"
.Vb 2
\&  va = require( \*(Aqvalidate.args\*(Aq )
\&  vobj = va:new( args )
.Ve
.Sp
This constructs a new validation object based upon either the class
defaults or the current defaults (as set by the \fB\f(BIopts()\fB\fR and
\&\fB\f(BIadd_type()\fB\fR functions).  It takes a table of named arguments:
.RS 4
.IP "use_current_options" 4
.IX Item "use_current_options"
If true, the values of the object's validation options are taken from
the current option values set by the \f(CW\*(C`opts()\*(C'\fR function.  If false
(the default), the options have the default values specified above.
.IP "use_current_types" 4
.IX Item "use_current_types"
If true, the validation types are taken from
the current values set by the \f(CW\*(C`add_type()\*(C'\fR function.  If false
(the default), the options have the default values specified above.
.IP "use_current" 4
.IX Item "use_current"
This is equivalent to specifying both \f(CW\*(C`use_current_types\*(C'\fR and
\&\f(CW\*(C`use_current_options\*(C'\fR to the same value.
.RE
.RS 4
.RE
.IP "Object constructor" 4
.IX Item "Object constructor"
.Vb 5
\&  \-\- create and specialize an object
\&  va = require( \*(Aqvalidate.args\*(Aq )
\&  vobj = va:new( args )
\&  vobj:add_type( ... )
\&  vobj.opts.xxx = yyy
\&
\&  \-\- now create an independent copy of it
\&  nobj = vobj:new()
.Ve
.Sp
This creates an independent copy of the \f(CW\*(C`vobj\*(C'\fR object, including all
of its options and types.  This is useful for nested specialization of
types and options.
.Sp
\&\fBWarning!\fR Only a shallow copy of the objects' validation options is made;
if any of the option values are tables (e.g. \f(CW\*(C`udata\*(C'\fR) the options in the
new object will refer to the same tables as in the original object.
.Sp
\&\fBDo not rely upon this behavior.\fR
.PP
\fIMethods\fR
.IX Subsection "Methods"
.IP "setopts" 4
.IX Item "setopts"
.Vb 4
\&  vobj:setopts{ opt1 = val1, opt2 = val2 }
\&  \-\- or
\&  vobj.opts.opt1 = val1
\&  vobj.opts.opt2 = val2
.Ve
.Sp
Set the specified validation options (See \*(L"Validation Options\*(R" for
the valid options).  These hold for this object only. An error will be
thrown if the specified options are not recognized.
.IP "add_type" 4
.IX Item "add_type"
.Vb 1
\&   vobj:add_type( type_name, func )
.Ve
.Sp
Register a validation function for the named type which
will be accepted by the \fBtype\fR validation attribute.
.Sp
The function will be passed the value of the element to validate.  It should
return two values:
.RS 4
.IP "1." 4
a boolean indicating success or failure;
.IP "2." 4
the (possibly modified) element value upon success, an error message upon failure
.RE
.RS 4
.Sp
For example, the following
.Sp
.Vb 8
\&  vobj:add_type( \*(Aqmytype\*(Aq, function( arg )
\&                          if \*(Aqnumber\*(Aq == type(arg) then
\&                            return true, 3 * arg
\&                          else
\&                            return false, \*(Aqnot a number between 2 & 3\*(Aq
\&                          end
\&                      end
\&          )
.Ve
.Sp
adds a new type called \f(CW\*(C`mytype\*(C'\fR which accepts only numbers between 2
and 3 (exclusive) and modifies the element value by multiplying it by 3.
.RE
.IP "validate" 4
.IX Item "validate"
.Vb 1
\&  vobj:validate( specs, ... )
.Ve
.Sp
Validate the passed  list against the specifications.  It
returns a list of values.  The first value is a boolean indicating
whether or not the validation succeeded.
.Sp
If validation succeeded, the remainder of the list contains the
values (possibly modified during the validation).
.Sp
If validation failed, the second value is a string indicating what
caused the failure.
.IP "validate_tbl" 4
.IX Item "validate_tbl"
.Vb 1
\&  vobj:validate_tbl( specs, table )
.Ve
.Sp
Validate the contents of the passed table against the
specifications. The return values are the same as for \fBvalidate\fR.
.IP "getopt" 4
.IX Item "getopt"
.Vb 1
\&  vobj:getopt( opt )
.Ve
.Sp
Returns the value of the specified option.  Throws an error if the
option does not exist.
.SS "Procedural interface"
.IX Subsection "Procedural interface"
.IP "validate( specs, ... )" 4
.IX Item "validate( specs, ... )"
.Vb 1
\&  validate( specs, ... )
.Ve
.Sp
Validate the passed list against the specifications using the
current global settings for the validation options.  See the
documentation for the \f(CW\*(C`validate()\*(C'\fR method for more details.
.IP "validate_opts" 4
.IX Item "validate_opts"
.Vb 1
\&  validate_opts( opts, specs, ... )
.Ve
.Sp
Validate the passed list against the specifications using the
current global settings for the validation options.  Temporary values
for validations options may be specified with the \f(CW\*(C`opts\*(C'\fR argument. The
return values are the same as \fBvalidate\fR.
.IP "validate_tbl" 4
.IX Item "validate_tbl"
.Vb 1
\&  validate_tbl( opts, specs, tble )
.Ve
.Sp
Validate the contents of the passed table against the specifications
using the current global settings for the validation
options. Temporary values for validations options may be specified
with the \f(CW\*(C`opts\*(C'\fR argument. The validation workflow may be altered via
options passed via the \f(CW\*(C`opts\*(C'\fR argument.  The return values are the
same as \fBvalidate\fR.
.IP "add_type" 4
.IX Item "add_type"
.Vb 1
\&  add_type( type_name, func )
.Ve
.Sp
Globally register a validation function for the named type which
will be accepted by the \fBtype\fR validation attribute.  See the
\&\f(CW\*(C`add_type()\*(C'\fR method for more details on the arguments.
.Sp
The function will be passed the value of the element to validate.  It should
return two values:
.IP "opts( \fItable of options\fR )" 4
.IX Item "opts( table of options )"
Globally set the values for the passed options.  See \*(L"Validation
Options\*(R" for the available options.
.IP "posnum( arg )" 4
.IX Item "posnum( arg )"
Test if \f(CW\*(C`arg\*(C'\fR is a number greater than zero.
Returns true upon success, false and and error message if not.
.IP "zposnum( arg )" 4
.IX Item "zposnum( arg )"
Test if \f(CW\*(C`arg\*(C'\fR is a number greater or equal to zero.
Returns true upon success, false and and error message if not.
.IP "posint( arg )" 4
.IX Item "posint( arg )"
Test if \f(CW\*(C`arg\*(C'\fR is a integer greater than zero.
Returns true upon success, false and and error message if not.
.IP "zposint( arg )" 4
.IX Item "zposint( arg )"
Test if \f(CW\*(C`arg\*(C'\fR is an integer greater or equal to zero.
Returns true upon success, false and and error message if not.
.SH "EXAMPLES"
.IX Header "EXAMPLES"
.IP "\(bu" 4
Named parameters, some optional
.Sp
.Vb 6
\&  function foo( ... )
\&    local ok, args = validate( { a = { type = \*(Aqnumber\*(Aq },
\&                                 b = { default  = 22,
\&                                       type = \*(Aqnumber\*(Aq },
\&                     }, ... )
\&  end
.Ve
.Sp
If called as
.Sp
.Vb 1
\&  foo{ a = 12 }
.Ve
.Sp
then
.Sp
.Vb 2
\&  args.a = 12
\&  args.b = 22
.Ve
.IP "\(bu" 4
Positional parameters and optional named ones
.Sp
.Vb 10
\&  function bar( ... )
\&    local ok, arg1, arg2, opts
\&                   = validate( { { type = \*(Aqstring\*(Aq },
\&                                 { type = \*(Aqnumber\*(Aq },
\&                                 { vtable = {
\&                                     a = { default = true,
\&                                           type = \*(Aqboolean\*(Aq },
\&                                     b = { default = 22,
\&                                           type = \*(Aqnumber\*(Aq },
\&                                   },
\&                                 }
\&                               }, ... )
\&  end
.Ve
.Sp
If called as
.Sp
.Vb 1
\&  bar( \*(Aqa\*(Aq, \*(Aq22\*(Aq, { b = 33 } )
.Ve
.Sp
then
.Sp
.Vb 4
\&  arg1 = \*(Aqa\*(Aq
\&  arg2 = 22
\&  opts.a = true
\&  opts.b = 33
.Ve
.IP "\(bu" 4
vtable functions
.Sp
In this example a function (\f(CW\*(C`foo()\*(C'\fR) takes a named parameter, \f(CW\*(C`idist\*(C'\fR, which
describes a random number distribution and its parameters:
.Sp
.Vb 2
\&  foo( idist = { \*(Aqgaussian\*(Aq, sigma = 33 } );
\&  foo( idist = { \*(Aqpowerlaw\*(Aq, alpha = 1.5 } );
.Ve
.Sp
\&\f(CW\*(C`idist\*(C'\fR is a table with the name of the distribution as the first
positional value and its parameters as subsequent named parameters.
Each random number distribution has different parameters, so a simple
specification cannot be written which would cover all possible cases.
This is where using a vtable function makes it easy.
.Sp
First, create a table containing validation specifications for each
of the distributions.  The distribution names are the keys:
.Sp
.Vb 4
\&  specs = { gaussian = { {}, sigma = { type = \*(Aqnumber\*(Aq } },
\&            uniform  = { {},  },
\&            powerlaw = { {}, alpha = { type = \*(Aqnumber\*(Aq } },
\&          }
.Ve
.Sp
The specifications are used to validate the entire contents of idist,
so the name of the distribution must be validated as well (hence the
\&\f(CW\*(C`{}\*(C'\fR as the first element in the specification table).  Later, in the
full validation specification for \f(CW\*(C`foo()\*(C'\fR, \f(CW\*(C`idist\*(C'\fR is validated
using a vtable function which selects the correct validation
specification based upon the value of the first positional element
(the name of the function):
.Sp
.Vb 8
\&  { idist = { vtable = function (arg)
\&                          local vtable = specs[arg[1]]
\&                          if vtable then
\&                            return true, vtable
\&                          else
\&                            return false, "unknown idist: " .. tostring(arg)
\&                          end
\&                       end } }
.Ve
.IP "\(bu" 4
Homogeneous Lists
.Sp
In this example, an element may be a list of numbers.
.Sp
.Vb 1
\&  { multiple = true, type = \*(Aqnumber\*(Aq }
.Ve
.IP "\(bu" 4
Heterogeneous Lists
.Sp
In this example, an element may be a list of enumerated strings or
non-negative integers.
.Sp
.Vb 6
\&  { multiple = true,
\&    type = { \*(Aqzposnum\*(Aq,
\&              [\*(AqFood Groups\*(Aq] =
\&                  { enum = { \*(AqFruit\*(Aq, \*(AqBread\*(Aq, \*(AqSnacks\*(Aq } }
\&            }
\&  }
.Ve
.SH "AUTHOR"
.IX Header "AUTHOR"
Diab Jerius, <djerius@cfa.harvard.edu>
.SH "COPYRIGHT AND LICENSE"
.IX Header "COPYRIGHT AND LICENSE"
Copyright (C) 2010\-2011 by the Smithsonian Astrophysical Observatory
.PP
This software is released under the \s-1GNU\s0 General Public License.
You may find a copy at <http://www.fsf.org/copyleft/gpl.html>.
