#!/opt/conda/envs/ciao-4.17.0/bin/python3
# 
#  Copyright (C) 2008,2011-2012,2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

from __future__ import print_function

from pytransform import *
from numpy import array
import numpy
from os import environ


#  Setup input/output directories
#
testin  = environ.get('TESTIN')
if testin == None :
  indir = environ.get('PWD')
else :
  indir = testin + '/test_transform'

testout = environ.get('TESTOUT')
if testout == None :
  outdir = environ.get('PWD')
else :
  outdir = testout + '/transform'

print("\n************************************************************")
print("                      SPLITTransform                           ")
print("************************************************************")
#
# Wrapped and running
#   SPLITTransform();
#   SPLITTransform(string in_name);
#   SPLITTransform(string in_name, list<TransParam*> in_params);
#   SPLITTransform(string in_name, SPLITTransform&);
#
#   string get_name();
#   void   set_name(string in_name);
#
#   void set_parameter_list(list<TransParam*> in_params);
#   list<TransParam*> get_parameter_list();
#   void print_parameter_list();
#
#   trErrCode  set_parameter(TransParam* in_param);
#   TransParam* get_parameter(string in_name);
#   void*      get_parameter_value(string in_name);
#
#   void* apply(void* in_array, dmDataType in_datatype);
## ----------------------------------------------------------------------
print("\nCreate SPLIT Transform object")
T1 = SPLITTransform()
print("  T1 = SPLITTransform()... OK")

print("\nDisplay Default Parameter Info")
print("  T1.print_parameter_list()...")
print(T1.print_parameter_list())

# ----------------------------------------------------------------------
print("\nCreate SPLIT Transform object with name.")
T2 = SPLITTransform("T2")
print("  T2 = SPLITTransform('T2')... OK")

print("\nDisplay Default Parameter Info")
print("  T2.print_parameter_list()...")
print(T2.print_parameter_list())

# ----------------------------------------------------------------------
print("\nName handling")

name = T2.get_name()
print("  T2.get_name()            => ", name)

T1.set_name("T1")
print("  T1.set_name('T1')")
print("  T1.get_name()            => ", T1.get_name())

# ----------------------------------------------------------------------

print("\nDisplay Parameter Info")
print("  T1.print_parameter_list()...")
print(T1.print_parameter_list())

print("\n  T2.print_parameter_list()...")
print(T2.print_parameter_list())


# ----------------------------------------------------------------------


print("\nUpdate Parameters in T1 SPLITTransform")
tpar = T1.get_parameter("CPT_NUMBER")
tpar.set_value(1)

tpar = T1.get_parameter("VDIM")
tpar.set_value(2)

print("\nDisplay T1 Parameter Info")
print(T1.print_parameter_list())

print("\nUpdate Parameters in T2 SPLITTransform")
tpar = T2.get_parameter("CPT_NUMBER")
tpar.set_value(2)

tpar = T2.get_parameter("VDIM")
tpar.set_value(2)

print("\nDisplay T2 Parameter Info")
print(T2.print_parameter_list())


# ----------------------------------------------------------------------

print("\n- Set input EQPOS(RA, DEC) data array")
eqpos = array([[359.9551312322,    -0.00510861266032],
               [359.9632226695,      0.0001721822709],
               [359.9609486838,    -0.00210187580974],
               [359.9909124608,     0.01019157628795],
               [359.9629239536,    -0.00510149994606],
               [359.9320931489,     0.01085198494395],
               [359.9088332073,     0.00757528471339],
               [359.9053199741,     0.00755191511017],
               [359.9899470886,     0.00179692015965],
               [359.9172396452,    -0.00341470866933]], dtype=numpy.double)

for ii in range(0, len(eqpos)) :
  print("   ", eqpos[ii][0], ",", eqpos[ii][1]) 

print("\n- Apply Transform; Get Values from Component 1")
ra = T1.apply(eqpos)
print(ra)

print("\n- Apply Transform; Get Values from Component 2")
dec = T2.apply(eqpos)
print(dec)

# ----------------------------------------------------------------------

print("\nDone.\n")
