# 
#  Copyright (C) 2007-2016,2024  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

# 
# NOTE: THIS BLOCK IS NO LONGER ACCURATE.
#    With the implementation of SL-404, this file has been modified directly.
#    SWIG is no longer part of the system, and we are in the process of 
#    migrating this package to a direct-binding implementation.  
#
#    SL-404 : is to remove dependency on 'imp' module which is deprecated.
#
# ------------------------------ CUT ---------------------------------------
#
# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.5
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.



from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname,join
        import importlib.util
        import importlib.machinery 

        
        # Determine the correct extension suffix dynamically
        # sysconfig provide the extension in 
        # >>> import sysconfig
        # >>> ext = sysconfig.get_config_var('EXT_SUFFIX')
        #  for Linux, python v3.10.9 : ext ='.cpython-310-x86_64-linux-gnu.so'
        #      macOS, python v3.12.4 : ext_='.cpython-312-darwin.so'
        # Note that importlib can provide the extension(s)
        # >>> import importlib
        # >>> ext=importlib.machinery.EXTENSION_SUFFIXES 
        # >>> len(ext)
        # 3
        # >>> ext[0]
        # '.cpython-310-x86_64-linux-gnu.so'  --> falling in sysconfig's extn above
        # >>> ext[1]
        # '.abi3.so'                          --> stable ABI (Application Binary Interface) version 3.
        # >>> ext[2]
        # '.so'                               --> a generic suffix
        # For consistency, use imporlib's; for the current build system, use ext[0] directly,  
        #  ext = importlib.machinery.EXTENSION_SUFFIXES[0]  
        # but loop the extensions to find the right one dynamically
    
        # Form the module-lib (.so) in naming convention
        module_name = '_pytransform'            
        module_loaded = False
        _mod = None
        
        # looping the extensions
        for ext_suffix in importlib.machinery.EXTENSION_SUFFIXES:
            module_file = join(dirname(__file__), f"{module_name}{ext_suffix}")
            
            try:
                # Use importlib to load the module from the named module-name
                spec = importlib.util.spec_from_file_location(module_name, module_file)
                if spec is None:
                    continue
                _mod = importlib.util.module_from_spec(spec)
                spec.loader.exec_module(_mod)
                module_loaded = True
                break
            except (ImportError, FileNotFoundError):
                continue
        
        if not module_loaded:
            try:
                import _pytransform
                return _pytransform
            except ImportError:
                raise ImportError(f"Could not load the module '{module_name}' with any of the known suffixes.")
        
        return _mod
    
    _pytransform = swig_import_helper()
    del swig_import_helper
else:
    import _pytransform
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _pytransform.SwigPyIterator_value(self)
    def incr(self, n=1): return _pytransform.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _pytransform.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _pytransform.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _pytransform.SwigPyIterator_equal(self, *args)
    def copy(self): return _pytransform.SwigPyIterator_copy(self)
    def next(self): return _pytransform.SwigPyIterator_next(self)
    def __next__(self): return _pytransform.SwigPyIterator___next__(self)
    def previous(self): return _pytransform.SwigPyIterator_previous(self)
    def advance(self, *args): return _pytransform.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _pytransform.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _pytransform.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _pytransform.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _pytransform.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _pytransform.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _pytransform.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _pytransform.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def get_pyType(*args):
  return _pytransform.get_pyType(*args)
get_pyType = _pytransform.get_pyType

def get_dmType(*args):
  return _pytransform.get_dmType(*args)
get_dmType = _pytransform.get_dmType

def get_dmType_str(*args):
  return _pytransform.get_dmType_str(*args)
get_dmType_str = _pytransform.get_dmType_str

def cxc_strings_to_carray(*args):
  return _pytransform.cxc_strings_to_carray(*args)
cxc_strings_to_carray = _pytransform.cxc_strings_to_carray

def cxc_bytes_to_unicode(*args):
  return _pytransform.cxc_bytes_to_unicode(*args)
cxc_bytes_to_unicode = _pytransform.cxc_bytes_to_unicode

def cxc_str_as_char(*args):
  return _pytransform.cxc_str_as_char(*args)
cxc_str_as_char = _pytransform.cxc_str_as_char

def cxc_create_params_list(*args):
  return _pytransform.cxc_create_params_list(*args)
cxc_create_params_list = _pytransform.cxc_create_params_list
class Transform(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Transform, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Transform, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_Transform
    __del__ = lambda self : None;
    def get_className(self): return _pytransform.Transform_get_className(self)
    def get_name(self): return _pytransform.Transform_get_name(self)
    def set_name(self, *args): return _pytransform.Transform_set_name(self, *args)
    def get_parameter_list(self): return _pytransform.Transform_get_parameter_list(self)
    def get_parameter(self, *args): return _pytransform.Transform_get_parameter(self, *args)
    def get_parameter_value(self, *args): return _pytransform.Transform_get_parameter_value(self, *args)
    def set_parameter_list(self, *args): return _pytransform.Transform_set_parameter_list(self, *args)
    def set_parameter(self, *args): return _pytransform.Transform_set_parameter(self, *args)
    def print_parameter_list(self): return _pytransform.Transform_print_parameter_list(self)
    def apply(self, *args): return _pytransform.Transform_apply(self, *args)
    def invert(self, *args): return _pytransform.Transform_invert(self, *args)
    def get_transform_matrix(self): return _pytransform.Transform_get_transform_matrix(self)
    def set_transform_matrix(self, *args): return _pytransform.Transform_set_transform_matrix(self, *args)
    def copy(self): return _pytransform.Transform_copy(self)
    def __init__(self, *args): 
        this = _pytransform.new_Transform(*args)
        try: self.this.append(this)
        except: self.this = this
Transform_swigregister = _pytransform.Transform_swigregister
Transform_swigregister(Transform)

class WCSTransform(Transform):
    __swig_setmethods__ = {}
    for _s in [Transform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WCSTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [Transform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WCSTransform, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_WCSTransform
    __del__ = lambda self : None;
    def copy(self): return _pytransform.WCSTransform_copy(self)
    def get_parameter_list(self): return _pytransform.WCSTransform_get_parameter_list(self)
    def apply(self, *args): return _pytransform.WCSTransform_apply(self, *args)
    def invert(self, *args): return _pytransform.WCSTransform_invert(self, *args)
    def get_transform_matrix(self): return _pytransform.WCSTransform_get_transform_matrix(self)
    def set_transform_matrix(self, *args): return _pytransform.WCSTransform_set_transform_matrix(self, *args)
    def __init__(self, *args): 
        this = _pytransform.new_WCSTransform(*args)
        try: self.this.append(this)
        except: self.this = this
WCSTransform_swigregister = _pytransform.WCSTransform_swigregister
WCSTransform_swigregister(WCSTransform)

class WCSTANTransform(Transform):
    __swig_setmethods__ = {}
    for _s in [Transform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WCSTANTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [Transform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WCSTANTransform, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_WCSTANTransform
    __del__ = lambda self : None;
    def copy(self): return _pytransform.WCSTANTransform_copy(self)
    def get_parameter_list(self): return _pytransform.WCSTANTransform_get_parameter_list(self)
    def apply(self, *args): return _pytransform.WCSTANTransform_apply(self, *args)
    def invert(self, *args): return _pytransform.WCSTANTransform_invert(self, *args)
    def get_transform_matrix(self): return _pytransform.WCSTANTransform_get_transform_matrix(self)
    def set_transform_matrix(self, *args): return _pytransform.WCSTANTransform_set_transform_matrix(self, *args)
    def __init__(self, *args): 
        this = _pytransform.new_WCSTANTransform(*args)
        try: self.this.append(this)
        except: self.this = this
WCSTANTransform_swigregister = _pytransform.WCSTANTransform_swigregister
WCSTANTransform_swigregister(WCSTANTransform)

class LINEAR2DTransform(Transform):
    __swig_setmethods__ = {}
    for _s in [Transform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LINEAR2DTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [Transform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LINEAR2DTransform, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_LINEAR2DTransform
    __del__ = lambda self : None;
    def copy(self): return _pytransform.LINEAR2DTransform_copy(self)
    def get_parameter_list(self): return _pytransform.LINEAR2DTransform_get_parameter_list(self)
    def apply(self, *args): return _pytransform.LINEAR2DTransform_apply(self, *args)
    def invert(self, *args): return _pytransform.LINEAR2DTransform_invert(self, *args)
    def get_transform_matrix(self): return _pytransform.LINEAR2DTransform_get_transform_matrix(self)
    def set_transform_matrix(self, *args): return _pytransform.LINEAR2DTransform_set_transform_matrix(self, *args)
    def get_inverse_matrix(self): return _pytransform.LINEAR2DTransform_get_inverse_matrix(self)
    def __init__(self, *args): 
        this = _pytransform.new_LINEAR2DTransform(*args)
        try: self.this.append(this)
        except: self.this = this
LINEAR2DTransform_swigregister = _pytransform.LINEAR2DTransform_swigregister
LINEAR2DTransform_swigregister(LINEAR2DTransform)

class SPLITTransform(Transform):
    __swig_setmethods__ = {}
    for _s in [Transform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SPLITTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [Transform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SPLITTransform, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_SPLITTransform
    __del__ = lambda self : None;
    def copy(self): return _pytransform.SPLITTransform_copy(self)
    def get_parameter_list(self): return _pytransform.SPLITTransform_get_parameter_list(self)
    def apply(self, *args): return _pytransform.SPLITTransform_apply(self, *args)
    def __init__(self, *args): 
        this = _pytransform.new_SPLITTransform(*args)
        try: self.this.append(this)
        except: self.this = this
SPLITTransform_swigregister = _pytransform.SPLITTransform_swigregister
SPLITTransform_swigregister(SPLITTransform)

class LINEARTransform(Transform):
    __swig_setmethods__ = {}
    for _s in [Transform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LINEARTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [Transform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LINEARTransform, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_LINEARTransform
    __del__ = lambda self : None;
    def copy(self): return _pytransform.LINEARTransform_copy(self)
    def get_parameter_list(self): return _pytransform.LINEARTransform_get_parameter_list(self)
    def apply(self, *args): return _pytransform.LINEARTransform_apply(self, *args)
    def invert(self, *args): return _pytransform.LINEARTransform_invert(self, *args)
    def __init__(self, *args): 
        this = _pytransform.new_LINEARTransform(*args)
        try: self.this.append(this)
        except: self.this = this
LINEARTransform_swigregister = _pytransform.LINEARTransform_swigregister
LINEARTransform_swigregister(LINEARTransform)

MAX_LENGTH = _pytransform.MAX_LENGTH
BUFFER_LENGTH = _pytransform.BUFFER_LENGTH
DT_VOID = _pytransform.DT_VOID
DT_INT2 = _pytransform.DT_INT2
DT_PTR = _pytransform.DT_PTR
DT_INT4 = _pytransform.DT_INT4
DT_REAL4 = _pytransform.DT_REAL4
DT_REAL8 = _pytransform.DT_REAL8
DT_CHAR = _pytransform.DT_CHAR
DT_UINT1 = _pytransform.DT_UINT1
DT_LOGICAL = _pytransform.DT_LOGICAL
DT_UNK = _pytransform.DT_UNK
DT_UINT2 = _pytransform.DT_UINT2
DT_UINT4 = _pytransform.DT_UINT4
DT_BIT = _pytransform.DT_BIT
dmSUCCESS = _pytransform.dmSUCCESS
dmFAILURE = _pytransform.dmFAILURE
class TransParam(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TransParam, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TransParam, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pytransform.delete_TransParam
    __del__ = lambda self : None;
    def clear(self): return _pytransform.TransParam_clear(self)
    def get_name(self): return _pytransform.TransParam_get_name(self)
    def get_value(self): return _pytransform.TransParam_get_value(self)
    def get_desc(self): return _pytransform.TransParam_get_desc(self)
    def get_parent(self): return _pytransform.TransParam_get_parent(self)
    def get_datatype(self): return _pytransform.TransParam_get_datatype(self)
    def get_nvals(self): return _pytransform.TransParam_get_nvals(self)
    def set_value(self, *args): return _pytransform.TransParam_set_value(self, *args)
    def set_parent(self, *args): return _pytransform.TransParam_set_parent(self, *args)
    def show(self): return _pytransform.TransParam_show(self)
    def __init__(self, *args): 
        this = _pytransform.new_TransParam(*args)
        try: self.this.append(this)
        except: self.this = this
TransParam_swigregister = _pytransform.TransParam_swigregister
TransParam_swigregister(TransParam)

# This file is compatible with both classic and new-style classes.


class TransformError(Exception):
	"Base class for all Transform exceptions."
	pass

from pytransform.hlui import *
