import sys, os, re, unittest
def regressionTest():
    path = os.path.abspath(os.path.dirname(sys.argv[0]))   
    files = os.listdir(path)                               
    tests_dir = os.path.join(os.path.dirname(__file__), '..', 'tests')
    files = [t for t in os.listdir(tests_dir) if t.startswith('test_') and t.endswith('.py')]
    filenameToModuleName = lambda f: os.path.splitext(f)[0]
    moduleNames = map(filenameToModuleName, files)         
    modules = map(__import__, moduleNames)                 
    load = unittest.defaultTestLoader.loadTestsFromModule  
    return unittest.TestSuite(map(load, modules))          
         
if __name__ == "__main__":
    unittest.main(defaultTest="regressionTest")

