try:
    # for python 3
    from abc import ABC 
except:
    # for python 2
    from abc import ABCMeta
    ABC=object

from abc import abstractmethod, abstractproperty

# This class follows the examples in Python Module of the Week 
#    https://pymotw.com/2/abc/
#
# This defines an Abstract Base Class with abstract properties, content and afterkey,
# which are common to both HistoryRecord and CommentRecord.
# 
# Concrete versions of the abstract methods and properties are implemented in 
# HistoryRecord and CommentRecord classes.

class Record (ABC):
    # for python 2
    try:
        __metaclass__ = ABCMeta
    except:
        pass

    #@abstractmethod
    def _get_afterkey(self):
        return 'Should never reach here'


    afterkey = abstractproperty(_get_afterkey)

    #@abstractmethod
    def _get_content(self):
        return 'Should never reach here'


    content = abstractproperty(_get_content)
