# 
#  Copyright (C) 2010-2011,2015-2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

"""

CXC DataModel API.

"""

import sys

from ._cxcdm import *
from cxcdm.cxcdm_dataset import *
from cxcdm.cxcdm_block import *
from cxcdm.cxcdm_descriptor import *

try:
    import ciao_version
    vstr = ciao_version.get_ciao_version()
except ImportError:
    print("Warning: Unable to load the ciao_version module to determine version number- defaulting 'cxcdm' version to 0.0.0");
    vstr = "0.0.0"


__all__ = ["dmDataset",
           "dmDatasetAccess",
           "dmDatasetAdvanceBlocks",
           "dmDatasetClose",
           "dmDatasetCreate",
           "dmDatasetCreateImage",
           "dmDatasetCreateTable",
           "dmDatasetDelete",
           "dmDatasetDestroy",
           "dmDatasetGetBlock",
           "dmDatasetGetBlockName",
           "dmDatasetGetBlockType",
           "dmDatasetGetCurrentBlockNo",
           "dmDatasetGetName",
           "dmDatasetGetNoBlocks",
           "dmDatasetMoveToBlock",
           "dmDatasetNextBlock",
           "dmDatasetOpen",
           "dmDatasetPrint",
           "dmDatasetWriteable",
           "dmBlock",
           "dmBlockAdvanceKeys",
           "dmBlockClose",
           "dmBlockCopy",
           "dmBlockCopyCol",
           "dmBlockCopyData",
           "dmBlockCopyWCS",
           "dmBlockCreate",
           "dmBlockCreateCopy",
           "dmBlockCreateGenCopy",
           "dmBlockCreateSubspaceCpt",
           "dmBlockCreateEmptySubspaceCpt",
           "dmBlockDelete",
           "dmBlockFlush",
           "dmBlockGetCurrSubspaceCpt",
           "dmBlockGetDataset",
           "dmBlockGetKey",
           "dmBlockGetKeyList",
           "dmBlockGetName",
           "dmBlockGetNo",
           "dmBlockGetNoKeys",
           "dmBlockGetNoSubspaceCpts",
           "dmBlockGetNoSubspaceCols",
           "dmBlockGetSubspace",
           "dmBlockGetSubspaceCol",
           "dmBlockGetType",
           "dmBlockIntersectSubspace",
           "dmBlockListKeys",
           "dmBlockMergeSubspace",
           "dmBlockMoveToKey",
           "dmBlockOpen",
           "dmBlockSetSubspaceCpt",
           "dmBlockSetBufferMaxSize",
           "dmBlockReadComment",
           "dmBlockWriteComment",
           "dmCopyGeneric",
           "dmTableAllocRow",
           "dmTableClose",
           "dmTableCreate",
           "dmTableGetNoCols",
           "dmTableGetNoRows",
           "dmTableGetRowNo",
           "dmTableGetRow",
           "dmTableGetRows",
           "dmTableNextRow",
           "dmTableOpen",
           "dmTableOpenColumn",
           "dmTableOpenColumnList",
           "dmTableReadRegion",
           "dmTableSetRow",
           "dmTableWriteRegion",
           "dmImageCreate",
           "dmImageGetDataDescriptor",
	   "dmImageGetData",
           "dmImageOpen",
           "dmImageClose",
           "dmImageSetData",
           "dmDescriptor",
           "dmDescriptorCompare",
           "dmDescriptorDelete",
           "dmDescriptorGetArea",
           "dmDescriptorGetBin",
           "dmDescriptorGetBlock",
           "dmDescriptorGetCoord",
           "dmDescriptorGetLength",
#           "dmGetElementType",
           "dmDescriptorGetType",
           "dmDescriptorGetNo",
           "dmDescriptorGetNoCoords",
           "dmDescriptorGetRange",
           "dmDescriptorGetNull",
           "dmDescriptorIsVarLength",
           "dmGetArrayDim",
           "dmGetArrayDimensions",
           "dmGetArraySize",
           "dmGetCurrentArraySize",
           "dmGetCpt",
           "dmGetCptName",
           "dmGetData",
           "dmGetDataType",
           "dmGetDesc",
           "dmGetDisp",
           "dmGetElementDim",
           "dmGetErrorMessage",
           "dmGetName",
           "dmGetUnit",
           "dmGetVersion",
	   "dmSetCptName",
	   "dmSetData",
           "dmSetDesc",
           "dmSetDisp",
           "dmSetName",
           "dmSetUnit",
           "dmDescriptorSetBin",
           "dmDescriptorSetNull",
           "dmDescriptorSetRange",
           "dmKeyOpen",
           "dmKeyRead",
           "dmKeyWrite",
           "dmColumnCreate",
           "dmResetErrorState",
           "dmSubspaceColCreate",
           "dmSubspaceColCreateRegion",
           "dmSubspaceColOpen",
           "dmSubspaceColGet",
           "dmSubspaceColGetRegion",
           "dmSubspaceColGetRegionString",
           "dmSubspaceColGetTableName",
           "dmSubspaceColRead",
           "dmSubspaceColSet",
           "dmSubspaceColSetRegion",
           "dmSubspaceColSetTableName",
           "dmSubspaceColUpdate",
           "dmArrayCreateAxisGroup",
           "dmArrayGetAxisGroup",
           "dmArrayGetNoAxisGroups",
           "dmIsEmpty",
           "dmCoordCalc",
           "dmCoordCreate",
           "dmCoordInvert",
           "dmCoordGetAxisGroupNo",
           "dmCoordGetParams",
           "dmCoordGetTransform",
           "dmCoordGetTransformType",
           "dmCoordSetParam",
           "dmCoordSetTransform",
           "dmBlockType","dmUNKBLOCK","dmTABLE","dmIMAGE",
           "dmDescriptorType",
           "dmTanPixToWorld",
           "dmTanWorldToPix",
           "dmBADDESC", "dmKEY", "dmSUBSPACE", "dmCOORD", "dmCOLUMN",
           "dmElementType", "dmVALUE", "dmINTERVAL", "dmRANGE",
           "dmNOMOREROWS", "dmENDOFTABLE", "dmGetElementType",
           "dmDESCNAME", "dmDESCVALUE", "dmDESCUNIT", "dmDESCKIND",
           "dmDESCTYPE", "dmDESCELMTYPE", "dmDESCDIM", "dmDESCLENS",
           "dmDESCELMDIM", "dmDESCCPTNAMES", "dmDESCCMNT", "dmDESCALL" 
           ]

__version__ = vstr

