import logging

logger = logging.getLogger()


def set_up_logger(verbosity, filename=None, pars=None, info=None):
    """
    Creates output debugging info

    Args:
      verbosity - int value that tells which level to set the logger
                  > 0, will print out the logging statements.
                  = 0 will only print out error statements
      filename - Name of the script that is calling the setup
      pars - dict of parameters from the script that is calling the setup
      info - dict with any additional info.  Some scripts have dictionaries
             of filenames, that can use this to print them out.

    Returns:
      Prints the appropriate logging information to the screen

    Assumptions:
    """
    formatter = logging.Formatter('%(asctime)s %(levelname)s: %(message)s')
    verbosity_level = {0: logging.WARNING,
                       1: logging.INFO,
                       2: logging.DEBUG}

    logger.setLevel(verbosity_level.get(verbosity, logging.DEBUG))

    ch = logging.StreamHandler()
    ch.setFormatter(formatter)
    logger.addHandler(ch)
    logger.info("=========================================")
    logger.info("Setting up the Logger for verbose output")
    logger.info("=========================================")

    if filename:
        logger.info("Running the script {}".format(filename))

    if pars:
        logger.info("==========All Parameters Used==========")
        for key, value in pars.items():
            logger.info("{0} = {1}".format(key, value))
        logger.info("=======================================")

    if info:
        logger.info("==========Additional Information=======")
        for key, value in info.items():
            logger.info("{0} = {1}".format(key, value))
        logger.info("=======================================")
