def print_results(processed_results):
    """
    Prints the contents of the results processed by process_results in a formatted manner, with IDs displayed as a
    comma-separated list for each category.

    Args:
    processed_results (dict): A dictionary with three sets, each containing specific IDs.
    """
    for category, ids_set in processed_results.items():
        if ids_set:
            print(f"{category}: ", end="")
            print(", ".join(sorted(ids_set)))  # Join IDs with commas and sort for consistency
    print("\n")
