import sys

import paramio as pio

from ..configuration import Category, Parameter, Boolean, boolean_converter


class ConfigurationFactory:
    def create(self, tool, **parameters):
        name = tool.name[:-3] if tool.name.endswith('.py') else tool.name
        if not parameters:
            parameters = get_params(tool=name, args=sys.argv)
        if 'mode' in parameters:
            del parameters['mode']
        return tool.configuration_class(**parameters)


class ParameterFileGenerator:
    def __init__(self, configuration_class):
        self.configuration_class = configuration_class

    def generate(self):
        result = ""
        for p in self.configuration_class.__parameters__.values():
            flag = datatype_flags.get(p.datatype, 's')
            default = convert_default(p)
            result += f'{p.name},{flag},h,{default},,,\n'
        return result


def convert_default(p: Parameter):
    if p.default is None:
        return ''
    converter = default_converters.get(p.__class__)
    return converter(p.default) if converter is not None else str(p.default)


datatype_flags = {
    int: 'i',
    float: 'f',
    boolean_converter: 'b',
}

default_converters = {
    Category: lambda x: x.value,
    Boolean: lambda x: 'yes' if x else 'no',
}


def get_params(tool, mode="rH", args=None):
    if None != args:
        pf = pio.paramopen(tool, mode, args)
    else:
        pf = pio.paramopen(tool, mode)
    pars = pio.plist(pf)

    values = []
    [values.append(pio.pget(pf, pp)) for pp in pars]

    pio.paramclose(pf)

    return dict(list(zip(pars, values)))
