############################################################################
# 
#  Copyright (C) 2008,2010  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#
# FILE NAME: setup_tools.sh
#
# DEVELOPMENT: CXCDS User Infrastructure Software
#
# DESCRIPTION:
#
#       This script configures the user environment obsvis.
#
#       This version of the script is written in the Bourne shell language,
#       but is compatible with ksh and bash, too.
#
############################################################################

RemovePath()            # Remove $2 from the path variable named by $1          
{
    if [ "eval '$'${1}x" != "x" ]; then
        _tmp=`eval echo '$'${1}`
        _tmp=`echo $_tmp | sed "s%$2%%g" | sed "s%::%:%g"`
        eval ${1}='$_tmp'
    fi
}

AddPathUnique()         #  Add $2 to path variable named by $1, uniquely        
{
    RemovePath "${1}" "${2}"
    eval _tmp="'$'${1}"
    if [ "x${_tmp}" != "x" ]; then
        eval "${1}"="${2}:${_tmp}"
    else
        eval "${1}"="${2}"
    fi
    export ${1}
}

# if we are not being called by ciao.sh setup the ciao.sh stuff

if [ "x${ASCDS_CIAO}" != "xciao" ] ; then
        ASCDS_CIAO="standalone"
	. /opt/conda/envs/ciao-4.17.0/bin/ciao.sh
fi

# setup package variables

################################################################
#                set Prop tools environment variables                #
################################################################

if [ -f /opt/conda/envs/ciao-4.17.0/VERSION.prop_tk ] ; then
  DATA_ROOT="/opt/conda/envs/ciao-4.17.0/config"
  JCMLIBDATA=${DATA_ROOT}/jcm_data

# The auxiliary ASCDS_PROP_NHBASE is set to allow use of the prop_colden 
#  wrapper script 
  ASCDS_PROP_NHBASE=${JCMLIBDATA}
  JCMPATH=${DATA_ROOT}/jcm_data

# The auxiliary ASCDS_PROP_DATE_DATA is set to allow use of the prop_dates 
#  wrapper script 
  ASCDS_PROP_DATE_DATA=${JCMPATH}

# The auxiliary ASCDS_PROP_PREC_DATA is set to allow use of the prop_precess 
#  wrapper script 
  ASCDS_PROP_PREC_DATA=${JCMPATH}

  export JCMLIBDATA
  export ASCDS_PROP_NHBASE
  export JCMPATH DATA_ROOT
  export ASCDS_PROP_DATE_DATA
  export ASCDS_PROP_PREC_DATA
fi

# By default CIAO will write local parameter files to $HOME/cxcds_param,
# but you may customize that by redefining LOCPFILES directly below

LOCPFILES=$HOME/cxcds_param4

if [ "$PFILES" != "" ] ; then
   _delimExists=`echo $PFILES | grep ';'`
   if [ "$_delimExists" != "" ]; then
      syspf=`echo $PFILES | sed "s%.*;%%"`
      locpf=`echo $PFILES | sed "s%;*$syspf$%%"`
   else
      locpf=$PFILES
   fi
   unset _delimExists
fi

AddPathUnique syspf /opt/conda/envs/ciao-4.17.0/param
AddPathUnique locpf $LOCPFILES

if [ -d "/opt/conda/envs/ciao-4.17.0/contrib/param" ] ; then
   AddPathUnique syspf /opt/conda/envs/ciao-4.17.0/contrib/param
fi

PFILES="$locpf;$syspf"

_tmp=`echo "$LOCPFILES" | sed "s%:% %g"`
for _dir in `echo "$_tmp"`
do
   if [ ! -d "$_dir" ] ; then
      mkdir $_dir     # if local param dir does exist, create it
   fi
done

export PFILES ASCDS_SYS_PARAM
unset locpf syspf tmp _tmp LOCPFILES

# Load CXCdefaults X resources file
#/opt/conda/envs/ciao-4.17.0/bin/cxcldres $ASCDS_QUIET

