############################################################################
# 
#  Copyright (C) 2008-2009  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#
# FILE NAME: obsvis_setup.sh
#
# DEVELOPMENT: CXCDS User Infrastructure Software
#
# DESCRIPTION:
#
#       This script configures the user environment obsvis.
#
#       This version of the script is written in the Bourne shell language,
#       but is compatible with ksh and bash, too.
#
############################################################################

RemovePath()            # Remove $2 from the path variable named by $1
{
    if [ "eval '$'${1}x" != "x" ]; then
        _tmp="`eval echo '$'${1}`"
        _tmp=`echo "$_tmp" | sed "s%$2%%g" | sed "s%::%:%g"`
        eval ${1}='$_tmp'
    fi
}

AddPathUnique()         #  Add $2 to path variable named by $1, uniquely
{
    RemovePath "${1}" "${2}"
    eval _tmp="'$'${1}"
    if [ "x${_tmp}" != "x" ]; then
	eval "${1}"="${2}:${_tmp}"
    else
        eval "${1}"="${2}"
    fi
    export ${1}
}

if [ "${ASCDS_CIAO}" != "ciao" ] ; then

################################################################
#               Setup for ASCDS Installation root              #
################################################################

   _nextASCDS_INSTALL=/opt/conda/envs/ciao-4.17.0

################################################################
#              set OBSVIS environment variables                #
################################################################

   if [ -x /opt/conda/envs/ciao-4.17.0/imager/ds9 ] ; then
       if [ "x${ASCDS_IMAGER_PATH}" != "x" ] ; then
           ASCDS_DUMMY="x"
       else
	   ASCDS_IMAGER_PATH="/opt/conda/envs/ciao-4.17.0/imager"
       fi
   fi

   OBSVIS_PKG_PATH=${_nextASCDS_INSTALL}/lib/tcltk/packages/obsvis
   export OBSVIS_PKG_PATH

################################################################
#              Export variables to environment                 #
################################################################

   export ASCDS_IMAGER_PATH
   if [ "x${ASCDS_WORK_PATH}" != "x" ] ; then
       ASCDS_DUMMY="x"
   else
       ASCDS_WORK_PATH="/tmp"
       export ASCDS_WORK_PATH
   fi

   AddPathUnique PATH $_nextASCDS_INSTALL/bin
   ASCDS_INSTALL=$_nextASCDS_INSTALL
   export ASCDS_INSTALL

   unset  AddPathUnique _nextASCDS_INSTALL _tmp
else
   OBSVIS_PKG_PATH=${ASCDS_INSTALL}/lib/tcltk/packages/obsvis
   export OBSVIS_PKG_PATH
fi
