local coords     = require( 'saotrace.raygen.coords' )
local spec_utils = require( 'saotrace.raygen.spectrum.utils' )
local raygen     = require( 'saotrace.raygen' )
local source   = require('saotrace.raygen.source.simple')
local tables     = require('saotrace.suplib.tables' )
local ea         = require('saotrace.raygen.ea.ideal')

local require    = require
local assert     = assert

local M = {}
setfenv( 1, M )

-- sanitize arguments sent to
-- saotrace.raygen.ea.create_from_db.entrance_aperture args may be an
-- environment returned by boxing a load of a file or string, so may
-- have trigger an "unexpected elements" validation error

function ea_wrap( args )

   return ea.entrance_aperture( tables.filter_matched_keys( ea.vspec, args ) )

end


config = require( 'saotrace.config' ).raygen
config.scripts.sources.func = source.default

-- trace-shell needs to provide the shell & db parameters
-- in config.scripts.entrance_aperture.args
config.scripts.entrance_aperture.func = ea_wrap

--------------------------
-- No symbols are exported
