#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <bpipe/bpipe.h>

/* simple print error and exit routine */
#define error(string)							\
  do {									\
      fprintf( stderr, __FILE__ " %d: %s\n", __LINE__, string );	\
      exit( EXIT_FAILURE );						\
     } while (0)

int 
main (int argc, char *argv[])
{
  BPipe *bpipe;
  BPipeOutput *bpo;
  DpktField *dpktf;

  BPMatrix *matrix;
  void *data;

  double init = 1.0;
  size_t i;

  size_t nphots = 1;
  
  if ( argc > 1 )
    nphots = atoi( argv[1] );

  if ( NULL == ( bpipe = bpipe_new( ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  matrix = bpipe_matrix_new_va( (size_t) 2, 1, 1 );
  /* create new data packet fields */
  if ( bpipe_dpktf_add( bpipe,	"weight",	BPDType_double,   matrix ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( NULL == ( bpo = bpipe_output( bpipe, "stdout" ) ) )
    error( bpipe_strerror( bpipe_errno ) );
    
  /* map data packet fields */
  if ( NULL == ( data = bpipe_map_alloc( bpipe, 1, NULL ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  /* output header */
  if ( bpipe_write_hdr(bpipe) )
    error( bpipe_strerror( bpipe_errno ) );

  /* get handles to data packet fields */
  dpktf = bpipe_dpktf( bpipe, "weight" );

  bpipe_dpktf_init( dpktf, data, &init );

  /* write the data packets out */
  for (i = 0; i < nphots ; i++)
    if ( bpipe_write_dpkt( bpipe, data, bpo ) )
      error( "error writing photon" );

  bpipe_delete(bpipe);

  return EXIT_SUCCESS;
}
