#ifndef OSACBPIPERAY_H
#define OSACBPIPERAY_H

/*H**************************************************************************
 *
 * Source     : ray.h
 * Author     : T. J. Gaetz
 * Version    : 0.1.0
 * Id String  : $Id: osacbpiperay.h,v 1.2 2004/07/16 18:57:46 dtn Exp $
 *
 * Description: modified fullray structure
 *
 * History:
 *   19960212[tjg]: adapt from fullray.h; convert to use datatypes.h
 *   19931105[tjg]: rename to fullray.h; remove some typedefs
 *   19931027[tjg]: split polar into c2, s2; add documentation 
 *                  on polarization
 *
 *H*/

#include <limits.h>

#include <bpipe/datatypes.h>

#include <saosacLib/bitmask.h>

typedef struct {
    DVector3     *pos;       /* ray position                              */
    DVector3     *dir;       /* ray direction vector (dir cosines)        */
    DVector3     *norm ;     /* surf normal, most recent reflection       */
    DVector3     *intersect_bcs; /* surface intercept in BCX              */
    double       *wt;        /* statistical weight of ray                 */
    double       *energy;    /* photon energy                             */
    double       *g_ang;     /* graze angle                               */
    DCVector2    *c2;        /* polarization amplitude (cosine comp)      */
    DCVector2    *s2;        /* polarization amplitude (sine comp)        */
    unsigned int *rayid;     /* ray id number                             */
    int          *raycode;   /* osac ray code                             */
    bitmask_t    *missed;    /* surface hit flags                         */
} Ray;

/* 
 * polarization state:   relation to OSAC polarization vectors
 *
 *      c2.q1 <--> c2comp(1),   c2.q2 <--> c2comp(2),   
 *      s2.q1 <--> s2comp(1),   s2.q2 <--> s2comp(2)
 *
 *   random polarization:
 *       wt =   c2.q1.r^2 + c2.q2.r^2 + c2.q1.i^2 + c2.q2.i^2 
 *            + s2.q1.r^2 + s2.q2.r^2 + s2.q1.i^2 + s2.q2.i^2 
 *
 *   discrete polarization:
 *       wt =   c2.q1.r^2 + c2.q2.r^2 + c2.q1.i^2 + c2.q2.i^2 
 *            + s2.q1.r^2 + s2.q2.r^2 + s2.q1.i^2 + s2.q2.i^2 
 *            + c2.q1.i s2.q1.r + c2.q2.i s2.q2.r
 *            - c2.q1.r s2.q1.i - c2.q2.r s2.q2.i
 */


#endif /* OSACBPIPERAY_H */



