# 
#  Copyright (C) 2007-2008,2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

from pytransform import *

__all__ = ('apply_transform', 'copy_transform', 'get_transform_type')
           

# ----------------------------------------------------------------------
def get_transform_type(transform):
    """
    get_transform_type(<transform>)

    Returns a string indicating the Transform Class Type.
    (e.g. 'WCSTANTransform', 'LINEAR2DTransform' )
    """    

    if not isinstance(transform,Transform):
        raise TypeError("Input object is not a Transform")

    try:
        ostr = transform.get_className()
    except:
        ostr = None

    return ostr

# ----------------------------------------------------------------------
def apply_transform(transform, data):
    """
    apply_transform(<transform>, data)

    Apply the specified transform to the given data, return the result.
    """    
    if transform is None:
        raise TransformError("No input Transform specified")

    if data is None:
        raise TransformError("No input data provided")

    if not isinstance(transform,Transform):
        raise TypeError("Input object is not a Transform")

    outarr = transform.apply( data )

    return outarr

# ----------------------------------------------------------------------
def copy_transform(transform):
    """
    copy_transform(<transform>)

    Creates a copy of the provided transform and returns it.
    """    

    if not isinstance(transform,Transform):
        raise TypeError("Input object is not a Transform")

    try:
        clname = transform.get_className()
    except:
        raise AttributeError("Can not obtain Transform class name")

    otran = None

    otran = transform.copy()

    if otran == None:
        msg = "Input Transform class not supported.. " + clname
        raise ValueError(msg)

    return otran
