#!/opt/conda/envs/ciao-4.17.0/bin/python3
# 
#  Copyright (C) 2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#


# July 21, 2016

# pypsf.t.py
# this file

# pypsf.t
# unix sh script, to activate pypsf.t.py for running regression testing

# OUTFILE
# global variables exported in pypsf.t

#------------  Beginning of Template ----------------------
# Support python 2 and 3
from __future__ import print_function

# import the package
from psf import *
import os  #used for environment vars
from numpy import isclose # for double comparison

#rename the function to get the environment variable for readability
getenv = os.environ.get

TESTID     = getenv('TESTID')
if( TESTID == None ):
     print("No TESTID specified\n")

OUTFILE = getenv('OUTFILE')
if( OUTFILE != None):
    OutFilePtr = open (OUTFILE, 'w')
    if( OutFilePtr == None):
        print("Unable to open %s\n" % OUTFILE)

INDIR = getenv('INDIR')
if ( INDIR == None ):
    print ("Cannot find input directory\n")

#------------  End of Template ----------------------

# !! 2
# Below are pecific subroutines for regression testing
#=============================================================================
#
#  --- Subroutines ---
#
#=============================================================================


# !!4
#=============================================================================
#
#   --- Main Routine ---
#
#=============================================================================

#Python does not have a native switch statement, so the code below
#tries to duplicate the C switch format/behavior

class switch(object):
    def __init__(self, value):
        self.value = value
        self.fall = False

    def __iter__(self):
        """Return the match method once, then stop"""
        yield self.match
        raise StopIteration

    def match(self, *args):
        """Indicate whether or not to enter a case suite"""
        if self.fall or not args:
            return True
        elif self.value in args:
            self.fall = True
            return True
        else:
            return False

# Error tolerance for double comparison
errtol = 0.0000001 

#Switch statement for TESTID
for case in switch(TESTID):
    if case('test1'):
      print("running  test1", file=OutFilePtr)
      filename = INDIR + "/hrmaD1996-12-20hrci_ecf_N0002.fits"
      print("reading file: ", file=OutFilePtr)
      print("<INDIR>/hrmaD1996-12-20hrci_ecf_N0002.fits", file=OutFilePtr)

      try:
           mypsf = psfInit()
      except TypeError as ex:
           pass
      except:
           print(ex)
           pass

      try:
           mypsf = psfInit(1)
      except TypeError as ex: 
           pass
      except:
           print(ex)
           pass


      try:
           mypsf = psfInit(999.99)
      except TypeError as ex: 
           pass
      except:
           print(ex)
           pass

      try:
           fname_bytes = bytes(filename, "utf-8")
      except TypeError:
           fname_bytes = bytes(filename)

      try:
           fname_unico = unicode(fname_bytes, "utf-8")
      except NameError:
           fname_unico = str(fname_bytes, "utf-8")


      # Init file
      try:
           mypsf = psfInit(fname_bytes)
      except Exception as ex:
           print("Error initializing psf with bytes string filename\n ", str(ex))
           pass

      try:
           mypsf = psfInit(fname_unico)
      except Exception as ex:
           print("Error initializing psf with unicode filename\n", str(ex))
           pass

      mypsf = psfInit(filename)

      # Compute size
      expectedSize = 3687.60166319
      size = psfSize(mypsf, 0.2475, 14.85, 0.1, 100.0)
      print("psfSize(mypsf, 0.2475, 14.85, 0.1, 100.0)", file=OutFilePtr)
      if isclose(expectedSize, size, errtol):
        print(expectedSize, file=OutFilePtr)
      else:
        print(size, file=OutFilePtr)

      # Compute frac
      expectedFrac = 1.0
      frac = psfFrac(mypsf, 0.2475, 14.85, 0.1, size)
      print("psfFrac(mypsf, 0.2475, 14.85, 0.1, size)", file=OutFilePtr)
      if isclose(expectedFrac, frac, errtol):
        print(expectedFrac, file=OutFilePtr)
      else:
        print(frac, file=OutFilePtr)

      # Close file
      ret = psfClose(mypsf)
      if (ret != None):
        print ("Failed to close psf", file=OutFilePtr)
      break
    if case(): # default
       print("Invalid TESTID")

OutFilePtr.close()
