def simple_progress_bar(current, total):
    """
    Displays a simple progress bar in the console.
    """
    bar_length = 40
    filled_length = int(round(bar_length * current / float(total)))
    percents = round(100.0 * current / float(total), 1)
    bar = '#' * filled_length + '-' * (bar_length - filled_length)
    print(f'[{bar}] {current}/{total} {percents}% Completed', end='\r')
    if current == total:
        print()
