import glob
import os
import fnmatch


def find_files_with_glob(directory=".", include_patterns=None, exclude_patterns=None):
    """
    Searches for files within a directory that match the include patterns but do not match the exclude patterns using glob.

    Args:
    directory (str): The directory to search within.
    include_patterns (list of str): Patterns of filenames to include.
    exclude_patterns (list of str): Patterns of filenames to exclude.

    Returns:
    list of str: A list of paths to files that match the include patterns but not the exclude patterns.
    """
    # Default to files ending in .fits or .fits.gz if no include patterns are provided
    if not include_patterns:
        include_patterns = ['**/*.fits', '**/*.fits.gz']
    if not exclude_patterns:
        exclude_patterns = []

    matched_files = []
    for pattern in include_patterns:
        # Form the full path pattern
        full_pattern = os.path.join(directory, pattern)
        for file_path in glob.glob(full_pattern, recursive=True):
            # Check against exclude patterns
            if not any(fnmatch.fnmatch(os.path.basename(file_path), ex_pattern) for ex_pattern in exclude_patterns):
                matched_files.append(file_path)

    return matched_files
