############################################################################
# 
#  Copyright (C) 2008,2010-2011  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#
# FILE NAME: setup_tools.csh.in
#
# DEVELOPMENT: CXCDS User Infrastructure Software
#
# DESCRIPTION:
#
#       This script configures the user environment obsvis.
#
#       This version of the script is written in the Bourne shell language,
#       but is compatible with ksh and bash, too.
#
############################################################################

# if we are not being called by ciao.sh setup the ciao.sh stuff

if ( "$?ASCDS_CIAO" ) then
   if ( "$ASCDS_CIAO" != "ciao" ) then
        setenv ASCDS_CIAO "standalone"
        source /opt/conda/envs/ciao-4.17.0/bin/ciao.csh
   endif
else
   setenv ASCDS_CIAO "standalone"
   source /opt/conda/envs/ciao-4.17.0/bin/ciao.csh
endif

# By default CIAO will write local parameter files to $HOME/cxcds_param,
# but you may customize that by redefining LOCPFILES directly below
set LOCPFILES="$HOME/cxcds_param4"

if ($?PFILES) then
   #  use the PFILES local dir value for the PDIRS local dir value
   set SYSPF = (`echo $PFILES | sed "s%.*;%%"`)
   set LOCPF = (`echo $PFILES | sed "s%;.*%%"`)
else
   set LOCPF = ""
   set SYSPF = ""
endif

if ( `echo $LOCPF | grep $LOCPFILES` != "" ) then
   set LOCPF = (`echo " $LOCPF " | sed "s%$LOCPFILES%%g"`)
endif
if ( $LOCPF != "" ) then
   set LOCPF = ${LOCPFILES}:${LOCPF}
else
   set LOCPF = ${LOCPFILES}
endif

if ( `echo $SYSPF | grep "$ASCDS_INSTALL/param"` != "" ) then
   set SYSPF = (`echo " $SYSPF " | sed "s%$ASCDS_INSTALL/param%%g"`)
endif

if ( $SYSPF != "" ) then
   set SYSPF = $ASCDS_INSTALL/param:${SYSPF}
else
   set SYSPF = $ASCDS_INSTALL/param
endif

if ( -e $ASCDS_CONTRIB/param ) then
   set SYSPF = $ASCDS_CONTRIB/param:${SYSPF}
endif

setenv PFILES "$LOCPF;$SYSPF"
setenv PFILES `echo "{$PFILES}" | sed "s%::%:%g"`

if ( -f /opt/conda/envs/ciao-4.17.0/VERSION.prop_tk ) then
    setenv DATA_ROOT "/opt/conda/envs/ciao-4.17.0/config"
    setenv JCMLIBDATA "$DATA_ROOT/jcm_data"
    setenv JCMPATH "$DATA_ROOT/jcm_data"
    setenv ASCDS_PROP_DATE_DATA "$JCMPATH"
    setenv ASCDS_PROP_PREC_DATA "$JCMPATH"
endif

set _tmp=`echo "$LOCPFILES" | sed "s%:% %g"`
foreach _dir (`echo "$_tmp"`) 
   if ( ! -d "$_dir" ) then
      mkdir $_dir     # if local param dir does not exist, create it
   endif 
end
unset _tmp 
