############################################################################
# 
#  Copyright (C) 2008-2012  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#
# FILE NAME: ciao_setup.sh
#
# DEVELOPMENT: CXCDS User Infrastructure Software
#
# DESCRIPTION:
#
#       This script configures the user environment for CIAO, the Chandra
#	X-Ray Center data analysis system.
#
#       When the script is sourced, it checks for the existence of an
#       ASCDS_INSTALL environment variable. If found, the script assumes
#       that the environment is already set up and exits with a warning
#       message. The user may override a previously set configuration by
#       setting the ASCDS_OVERRIDE environment variable (any value is
#       ok) and rerunning this script.
#
#       User customizations should be added to the 'USER CUSTOMIZATIONS'
#       section which appears slightly beyond the middle of this script.
#       If the user desires to modify the value of the installation root
#       (ASCDS_INSTALL) they should do so by setting the _nextASCDS_INSTALL
#       value at the beginning of the script. 
#
############################################################################

RemovePath()            # Remove $2 from the path variable named by $1          
{
    if [ "eval '$'${1}x" != "x" ]; then
        _tmp=`eval echo '$'${1}`
        _tmp=`echo $_tmp | sed "s%$2%%g" | sed "s%::%:%g"`
        eval ${1}='$_tmp'
    fi
}

AddPathUnique()         #  Add $2 to path variable named by $1, uniquely        
{
    RemovePath "${1}" "${2}"
    eval _tmp="'$'${1}"
    if [ "x${_tmp}" != "x" ]; then
        eval "${1}"="${2}:${_tmp}"
    else
        eval "${1}"="${2}"
    fi
    export ${1}
}

################################################################
#                  Handle command line options                 #
################################################################

# should we setup the ciao environment?
if [ "x${ASCDS_RUN_CONFIG}" != "xdone" ]; then  
   ASCDS_RUN_CONFIG="done"
   export ASCDS_RUN_CONFIG

################################################################
#                set CIAO environment variables                #
################################################################

#  DYLD_BIND_AT_LAUNCH=1
HEADAS="${CIAO_HEADAS}"
export HEADAS

################################################################
#                       IPython Setup                          #
################################################################

if [ "x${IPYTHONDIR}" != "x" ] ; then
    export IPYTHONDIR
else
    IPYTHONDIR="${HOME}/.ipython-ciao"
    export IPYTHONDIR
fi

################################################################
#              Export variables to environment                 #
################################################################

#  export DYLD_BIND_AT_LAUNCH

################################################################
#             setup AHELP_DEFCONTEXT if needed                 #
################################################################

if [ "x${AHELP_DEFCONTEXT}" = "x" ] ; then
    AHELP_DEFCONTEXT="/py[.]*/"
fi
export AHELP_DEFCONTEXT

################################################################
#                         Adjust paths                         #
################################################################

PYTHONPATH=$ASCDS_INSTALL/lib${CIAO_64}/python3.11/site-packages:$PYTHONPATH
export PYTHONPATH

# set LD_LIBRARY_PATH (or DYLD_LIBRARY_PATH) only if user already has it set
# to avoid potential conflicts.

if [ "x${LD_LIBRARY_PATH}" != "x" ] ; then
    export LD_LIBRARY_PATH="${ASCDS_INSTALL}/lib:${LD_LIBRARY_PATH}"
fi
#  if [ "x${DYLD_LIBRARY_PATH}" != "x" ] ; then
#     export DYLD_LIBRARY_PATH="${ASCDS_INSTALL}/lib:${DYLD_LIBRARY_PATH}"
#  fi
#  BWIDGET_LIBRARY=${ASCDS_LIB}
#  if [ "${CIAO_PYTHON}" == "CIAO" ] || [ "${CIAO_PYTHON}" == "${ASCDS_INSTALL}/bin" ] ; then
#     if [ -d $ASCDS_INSTALL/Library/Frameworks ] ; then
#        DYLD_FRAMEWORK_PATH=$ASCDS_INSTALL/Library/Frameworks:$DYLD_FRAMEWORK_PATH
#     fi
#  fi
#  export BWIDGET_LIBRARY DYLD_FRAMEWORK_PATH

################################################################
#                    Finished configuration                    #
################################################################

fi # end of if [ "x${ASCDS_RUN_CONFIG}" != "xdone" ]  - DO NOT DELETE THIS LINE
