-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.suplib
--
-- saotrace.suplib is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

require('string')

module( ... )

---------------------------------------------------------------------
-- splitpath - splits a path into directory and filename portions
function split( path )

    local istart, istop, dirname, basename = path:find( "(.*)/(.*)" )

    -- if find fails, no dirname just basename
    return dirname, basename or path
end

---------------------------------------------------------------------
-- returns true if the passed name is a legal Lua module name
function is_modname( name )

   local next
   local e = 0
   local s = true

   while s  do
      next = e + 1
      s, e = name:find('^[%w_]+%.', next )
   end

   s, e = name:find('^[%w_]+$', next )

   return s ~= nil

end
