-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of chandra.saotrace.aperture
--
-- saotrace.aperture is free software: you can redistribute it and/or
-- modify it under the terms of the GNU General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

local assert = assert
local require = require
local ideal = require( 'saotrace.aperture.ideal' )
local tables = require( 'saotrace.suplib.tables' )

local vobj = require( 'validate.args' ):new()
vobj:setopts{ named = true, allow_extra = true }

module( ... )

local assembly_map = {

   precollimator  = { optic = 'p', r = 'rho_f', z = 'z_f' },
   cap            = { optic = 'h', r = 'rho_f', z = 'z_f' },
   postcollimator = { optic = 'h', r = 'rho_a', z = 'z_a' },

}

local vspec = {

   shell         = { type = 'posnum' },
   assembly_name = { enum = tables.keys( assembly_map ) },
   config_db     = { type = 'string' },
}


function create_baffles( ... )


   local ok, args = vobj:validate( vspec, ... )
   assert( ok, args )

   local assembly = assembly_map[args.assembly_name]

   ideal.create_baffles{ shell = args.shell,
			 optic = assembly.optic,
			 name = args.assembly_name,
			 cols = {
			    x = 'x0',
			    y = 'y0',
			    z = assembly.z,
			    r = assembly.r
			 },
			 db = args.config_db
		      }

end


config = require('saotrace.config').aperture
config.script.func = create_baffles


return { create_baffles = create_baffles,
	 vspec = vspec
      }
