#ifndef SUPLIB_IMAGEFCTS_H
#define SUPLIB_IMAGEFCTS_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of suplib
 *
 * suplib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * suplib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum
{
  CVR_OK,
  CVR_LESSTHANTWO,
  CVR_MAXITER
} CenterVariterResults;

void
ave_dev_err( void *objs, size_t n_obj, size_t s_obj, double *x_ave,
	     double *x_ave_err, double *x_dev, double *x_dev_err,
	     double *tot_wt,
	     void (*get_stuff)(const void *obj, double *x, double
			       *x_err, double *w, double *w_err)
	     );

int center_variter(void *objs, void *work, unsigned long n_objs,
		   double tot_wt, size_t s_obj, double dtol,
		   double fvar, unsigned long max_iter,
		   unsigned long max_clip, double *center, double *dev_used,
		   size_t *n_used, double *wt_used, void **objs_used,
		   double (*get_x)(const void *obj, double *x),
		   void (*put_x)(void *obj, double x),
		   int (*comp)(const void *obj1, const void *obj2));

  
double weightpos(void *objs, unsigned long n_tot, double tot_wt,
		 size_t s_obj, double (*get_x)(const void *obj, double *x));

double wtvar(double x, void *objs, unsigned long n_obj, double tot_wt,
	     size_t s_obj, double (*get_x)(const void *obj, double *x));

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* SUPLIB_IMAGEFCTS_H */
