#ifndef rl_DielectricPOD_rdb_h_INCLUDED
#define rl_DielectricPOD_rdb_h_INCLUDED

// File:   rl_DielectricPOD_rdb.h
// Author: Terry Gaetz

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of rl_ray
 *
 * rl_ray is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * rl_ray is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

/****************************************************************************
 * Note       : (1-alpha) is real part of complex dielectric constant
 *              (-gamma)  is imag part of complex dielectric constant
 */

#include <cstddef>                    // ptrdiff_t
#include <rl_raylib/rl_Traits.h>      // rl_Traits::rl_DielectricPOD
#include <rl_raylib/rl_DielectricPODArray.h> 

//########################################################################
// rl_DielectricPOD_rdb
//########################################################################
//
/**
 * \class rl_DielectricPOD_rdb
 *
 * A class encapsulating reading of rl_DielectricPOD initialization data
 * from an rdb table.  The rdb table is assumed to have at least two data 
 * rows and 3 columns:
 * - energy (keV)
 * - alpha (real part of dielectric decrement)
 * - gamma (imaginary part of the dielectric decrement)
 *
 * The complex dielectric constant has real part (1-alpha) and 
 * imaginary part (-gamma).
 */

class rl_DielectricPOD_rdb
  : public rl_DielectricPODArray
{
public:

  /**
   * Destructor
   */
 ~rl_DielectricPOD_rdb();

  /**
   * Constructor.
   *
   * @param rdb_file name of the /rdb file to be read (optional).
   *     If rdb_file is a nonempty string, read in energy, alpha, 
   *     and gamma from the specified /rdb table.  The array is sorted on the
   *     energy field.  If rdb_file is an empty string, an empty
   *     uninitialized rl_DielectricPOD is created and the init method
   *     must be called to initialize the object.
   */
  rl_DielectricPOD_rdb( char const rdb_file[] = "" );

  /**
   * Initializer.
   *
   * @param rdb_file name of the /rdb file to be read.
   * rdb_file specifies the name of an /rdb table; energy, alpha, and gamma
   * are read in from the specified /rdb table.  The array is
   * sorted on the energy field.
   */
  void init( char const rdb_file[] );
};

// rl_DielectricPOD_rdb_h_INCLUDED
#endif
