-- saotrace.config.raygen.scripts.entrance_aperture script to
-- create entrance apertures from a list in a database.

local string = require('string')
local error = error
local assert = assert

local raygen = require( 'saotrace.raygen' )
local utils = require('saotrace.raygen.ea.utils.create_from_db')
local vobj = require( 'saotrace.raygen.validate' ).vobj:new()

local M = {}
setfenv( 1, M )

local vspec = {
   file  = { type = 'string' },
   shell = { type = 'posnum' },
}

-- this reads an RDB file which is indexed by shell
function entrance_aperture( ... )

   local ok, args = vobj:validate( vspec, ... )
   assert( ok, args )

   local pars = { file = args.file,
		  match = { shell = args.shell },
		  type = 'annulus'
	       }

   local nmatch = utils.create_from_db( pars )
   if nmatch ~= 1 then
      error( string.format( "error: %s : shell %d: got %d apertures, expected 1",
			    args.file, args.shell, nmatch  )
	  )
   end

end

-- return a sanitized namespace
return { entrance_aperture = entrance_aperture,

	 -- expose vspec so that inputs to entrance_aperture may be sanitized
	 -- to avoid "unknown elements" errors
	 vspec = vspec
      }
