#ifndef SUPLIB_LISTS_H
#define SUPLIB_LISTS_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of suplib
 *
 * suplib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * suplib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

const void *	bnd_bsearch(const void *key, const void *base, size_t n,
		    size_t size, const void **lo_bnd, const void **hi_bnd,
		    int (*cmp) (const void *keyval, const void *datum));

void *	partition(void *obj, void *p_obj, void *work, size_t s_obj,
		  unsigned long n_obj,
		  int (*obj_comp)(const void *obj1, const void *obj2));

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* SUPLIB_LISTS_H */
